/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations;

import java.util.Set;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.operations.AbstractShowOperation;
import org.apache.flink.table.operations.ExecutableOperation;
import org.apache.flink.table.operations.utils.ShowLikeOperator;

@Internal
public class ShowModelsOperation
extends AbstractShowOperation {
    @Nullable
    private final String databaseName;

    public ShowModelsOperation(@Nullable String catalogName, @Nullable String databaseName, @Nullable String preposition, @Nullable ShowLikeOperator likeOp) {
        super(catalogName, preposition, likeOp);
        this.databaseName = databaseName;
    }

    public ShowModelsOperation(@Nullable String catalogName, @Nullable String databaseName, @Nullable ShowLikeOperator likeOp) {
        this(catalogName, databaseName, null, likeOp);
    }

    @Nullable
    public String getDatabaseName() {
        return this.databaseName;
    }

    protected Set<String> retrieveDataForTableResult(ExecutableOperation.Context ctx) {
        CatalogManager catalogManager = ctx.getCatalogManager();
        if (this.preposition == null) {
            return catalogManager.listModels();
        }
        return catalogManager.listModels(this.catalogName, this.databaseName);
    }

    @Override
    protected String getOperationName() {
        return "SHOW MODELS";
    }

    @Override
    protected String getColumnName() {
        return "model name";
    }

    @Override
    public String getPrepositionSummaryString() {
        if (this.databaseName == null) {
            return super.getPrepositionSummaryString();
        }
        return super.getPrepositionSummaryString() + "." + this.databaseName;
    }
}

