/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api.bridge.internal;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.internal.TableEnvironmentImpl;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.ContextResolvedTable;
import org.apache.flink.table.catalog.ExternalCatalogTable;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.catalog.SchemaTranslator;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.delegation.Executor;
import org.apache.flink.table.delegation.ExecutorFactory;
import org.apache.flink.table.delegation.Planner;
import org.apache.flink.table.delegation.StreamExecutorFactory;
import org.apache.flink.table.expressions.ApiExpressionUtils;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.legacy.api.Types;
import org.apache.flink.table.module.ModuleManager;
import org.apache.flink.table.operations.DataStreamQueryOperation;
import org.apache.flink.table.operations.ExternalModifyOperation;
import org.apache.flink.table.operations.ExternalQueryOperation;
import org.apache.flink.table.operations.ModifyOperation;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.operations.utils.OperationTreeBuilder;
import org.apache.flink.table.resource.ResourceManager;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.table.typeutils.FieldInfoUtils;
import org.apache.flink.util.Preconditions;

@Internal
public abstract class AbstractStreamTableEnvironmentImpl
extends TableEnvironmentImpl {
    protected final StreamExecutionEnvironment executionEnvironment;

    public AbstractStreamTableEnvironmentImpl(CatalogManager catalogManager, ModuleManager moduleManager, ResourceManager resourceManager, TableConfig tableConfig, Executor executor, FunctionCatalog functionCatalog, Planner planner, boolean isStreamingMode, StreamExecutionEnvironment executionEnvironment) {
        super(catalogManager, moduleManager, resourceManager, tableConfig, executor, functionCatalog, planner, isStreamingMode);
        this.executionEnvironment = executionEnvironment;
    }

    public static Executor lookupExecutor(ClassLoader classLoader, StreamExecutionEnvironment executionEnvironment) {
        ExecutorFactory executorFactory;
        try {
            executorFactory = FactoryUtil.discoverFactory(classLoader, ExecutorFactory.class, "default");
        }
        catch (Exception e) {
            throw new TableException("Could not instantiate the executor. Make sure a planner module is on the classpath", e);
        }
        if (executorFactory instanceof StreamExecutorFactory) {
            return ((StreamExecutorFactory)executorFactory).create(executionEnvironment);
        }
        throw new TableException("The resolved ExecutorFactory '" + String.valueOf(executorFactory.getClass()) + "' doesn't implement StreamExecutorFactory.");
    }

    protected <T> Table fromStreamInternal(DataStream<T> dataStream, @Nullable Schema schema, @Nullable String viewPath, ChangelogMode changelogMode) {
        ContextResolvedTable contextResolvedTable;
        Preconditions.checkNotNull(dataStream, (String)"Data stream must not be null.");
        Preconditions.checkNotNull((Object)changelogMode, (String)"Changelog mode must not be null.");
        if (dataStream.getExecutionEnvironment() != this.executionEnvironment) {
            throw new ValidationException("The DataStream's StreamExecutionEnvironment must be identical to the one that has been passed to the StreamTableEnvironment during instantiation.");
        }
        CatalogManager catalogManager = this.getCatalogManager();
        OperationTreeBuilder operationTreeBuilder = this.getOperationTreeBuilder();
        SchemaTranslator.ConsumingResult schemaTranslationResult = SchemaTranslator.createConsumingResult(catalogManager.getDataTypeFactory(), dataStream.getType(), schema);
        ResolvedCatalogTable resolvedCatalogTable = catalogManager.resolveCatalogTable(new ExternalCatalogTable(schemaTranslationResult.getSchema()));
        if (viewPath != null) {
            UnresolvedIdentifier unresolvedIdentifier = this.getParser().parseIdentifier(viewPath);
            ObjectIdentifier objectIdentifier = catalogManager.qualifyIdentifier(unresolvedIdentifier);
            contextResolvedTable = ContextResolvedTable.temporary(objectIdentifier, resolvedCatalogTable);
        } else {
            contextResolvedTable = ContextResolvedTable.anonymous("datastream_source", resolvedCatalogTable);
        }
        ExternalQueryOperation<T> scanOperation = new ExternalQueryOperation<T>(contextResolvedTable, dataStream, schemaTranslationResult.getPhysicalDataType(), schemaTranslationResult.isTopLevelRecord(), changelogMode);
        List<String> projections = schemaTranslationResult.getProjections();
        if (projections == null) {
            return this.createTable(scanOperation);
        }
        QueryOperation projectOperation = operationTreeBuilder.project(projections.stream().map(ApiExpressionUtils::unresolvedRef).collect(Collectors.toList()), scanOperation);
        return this.createTable(projectOperation);
    }

    protected <T> DataStream<T> toStreamInternal(Table table, SchemaTranslator.ProducingResult schemaTranslationResult, @Nullable ChangelogMode changelogMode) {
        CatalogManager catalogManager = this.getCatalogManager();
        OperationTreeBuilder operationTreeBuilder = this.getOperationTreeBuilder();
        QueryOperation projectOperation = schemaTranslationResult.getProjections().map(projections -> operationTreeBuilder.project(projections.stream().map(ApiExpressionUtils::unresolvedRef).collect(Collectors.toList()), table.getQueryOperation())).orElseGet(table::getQueryOperation);
        ResolvedCatalogTable resolvedCatalogTable = catalogManager.resolveCatalogTable(new ExternalCatalogTable(schemaTranslationResult.getSchema()));
        ExternalModifyOperation modifyOperation = new ExternalModifyOperation(ContextResolvedTable.anonymous("datastream_sink", resolvedCatalogTable), projectOperation, changelogMode, schemaTranslationResult.getPhysicalDataType().orElseGet(() -> resolvedCatalogTable.getResolvedSchema().toPhysicalRowDataType()));
        return this.toStreamInternal(table, modifyOperation);
    }

    protected <T> DataStream<T> toStreamInternal(Table table, ModifyOperation modifyOperation) {
        List<Transformation<?>> transformations = this.planner.translate(Collections.singletonList(modifyOperation));
        Transformation<T> transformation = this.getTransformation(table, transformations);
        this.executionEnvironment.addOperator(transformation);
        this.resourceManager.addJarConfiguration(this.tableConfig);
        this.executionEnvironment.configure((ReadableConfig)this.tableConfig.getConfiguration());
        return new DataStream(this.executionEnvironment, transformation);
    }

    @Internal
    public StreamExecutionEnvironment execEnv() {
        return this.executionEnvironment;
    }

    protected <T> TypeInformation<T> extractTypeInformation(Table table, Class<T> clazz) {
        try {
            return TypeExtractor.createTypeInfo(clazz);
        }
        catch (Exception ex) {
            throw new ValidationException(String.format("Could not convert query: %s to a DataStream of class %s", table.getQueryOperation().asSummaryString(), clazz.getSimpleName()), ex);
        }
    }

    private <T> Transformation<T> getTransformation(Table table, List<Transformation<?>> transformations) {
        if (transformations.size() != 1) {
            throw new TableException(String.format("Expected a single transformation for query: %s\n Got: %s", table.getQueryOperation().asSummaryString(), transformations));
        }
        return transformations.get(0);
    }

    protected <T> DataType wrapWithChangeFlag(TypeInformation<T> outputType) {
        TupleTypeInfo tupleTypeInfo = new TupleTypeInfo(new TypeInformation[]{Types.BOOLEAN(), outputType});
        return TypeConversions.fromLegacyInfoToDataType(tupleTypeInfo);
    }

    protected <T> DataStreamQueryOperation<T> asQueryOperation(DataStream<T> dataStream, Optional<List<Expression>> fields) {
        TypeInformation streamType = dataStream.getType();
        FieldInfoUtils.TypeInfoSchema typeInfoSchema = fields.map(f -> {
            FieldInfoUtils.TypeInfoSchema fieldsInfo = FieldInfoUtils.getFieldsInfo(streamType, f.toArray(new Expression[0]));
            this.validateTimeCharacteristic(fieldsInfo.isRowtimeDefined());
            return fieldsInfo;
        }).orElseGet(() -> FieldInfoUtils.getFieldsInfo(streamType));
        return new DataStreamQueryOperation<T>(dataStream, typeInfoSchema.getIndices(), typeInfoSchema.toResolvedSchema());
    }

    protected void validateTimeCharacteristic(boolean isRowtimeDefined) {
        if (isRowtimeDefined && this.executionEnvironment.getConfig().getAutoWatermarkInterval() <= 0L) {
            throw new ValidationException(String.format("A rowtime attribute requires a positive watermark interval in stream environment. But is: %s", this.executionEnvironment.getConfig().getAutoWatermarkInterval()));
        }
    }

    @Override
    protected QueryOperation qualifyQueryOperation(ObjectIdentifier identifier, QueryOperation queryOperation) {
        if (queryOperation instanceof DataStreamQueryOperation) {
            DataStreamQueryOperation operation = (DataStreamQueryOperation)queryOperation;
            return new DataStreamQueryOperation(identifier, operation.getDataStream(), operation.getFieldIndices(), operation.getResolvedSchema());
        }
        return queryOperation;
    }

    public void attachAsDataStream(List<ModifyOperation> modifyOperations) {
        List<Transformation<?>> transformations = this.translate(modifyOperations);
        transformations.forEach(arg_0 -> ((StreamExecutionEnvironment)this.executionEnvironment).addOperator(arg_0));
    }
}

