/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.util;

import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Expressions;
import org.apache.flink.table.expressions.ApiExpressionUtils;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.FunctionContext;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.SpecializedFunction;
import org.apache.flink.table.types.DataType;
import org.apache.flink.util.FlinkRuntimeException;

@Internal
public class EqualityAndHashcodeProvider
implements Closeable,
Serializable {
    private final SpecializedFunction.ExpressionEvaluator hashcodeEvaluator;
    private final SpecializedFunction.ExpressionEvaluator equalityEvaluator;
    private transient MethodHandle hashcodeHandle;
    private transient MethodHandle equalityHandle;

    public EqualityAndHashcodeProvider(SpecializedFunction.SpecializedContext context, DataType dataType) {
        this.hashcodeEvaluator = context.createEvaluator((Expression)ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.INTERNAL_HASHCODE, (Expression[])new Expression[]{Expressions.$((String)"element1")}), DataTypes.INT(), new DataTypes.Field[]{DataTypes.FIELD((String)"element1", (DataType)((DataType)dataType.notNull()).toInternal())});
        this.equalityEvaluator = context.createEvaluator((Expression)Expressions.$((String)"element1").isEqual((Object)Expressions.$((String)"element2")), DataTypes.BOOLEAN(), new DataTypes.Field[]{DataTypes.FIELD((String)"element1", (DataType)((DataType)dataType.notNull()).toInternal()), DataTypes.FIELD((String)"element2", (DataType)((DataType)dataType.notNull()).toInternal())});
    }

    public void open(FunctionContext context) throws Exception {
        this.hashcodeHandle = this.hashcodeEvaluator.open(context);
        this.equalityHandle = this.equalityEvaluator.open(context);
    }

    public boolean equals(Object o1, Object o2) {
        try {
            return this.equalityHandle.invoke(o1, o2);
        }
        catch (Throwable e) {
            throw new FlinkRuntimeException(e);
        }
    }

    public int hashCode(Object o) {
        try {
            return this.hashcodeHandle.invoke(o);
        }
        catch (Throwable e) {
            throw new FlinkRuntimeException(e);
        }
    }

    @Override
    public void close() throws IOException {
        this.hashcodeEvaluator.close();
        this.equalityEvaluator.close();
    }
}

