/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.types;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.api.common.typeinfo.BasicArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.DecimalDataUtils;
import org.apache.flink.table.legacy.types.logical.TypeInformationRawType;
import org.apache.flink.table.runtime.types.TypeInfoLogicalTypeConverter;
import org.apache.flink.table.runtime.typeutils.BigDecimalTypeInfo;
import org.apache.flink.table.runtime.typeutils.DecimalDataTypeInfo;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.runtime.typeutils.LegacyInstantTypeInfo;
import org.apache.flink.table.runtime.typeutils.LegacyLocalDateTimeTypeInfo;
import org.apache.flink.table.runtime.typeutils.LegacyTimestampTypeInfo;
import org.apache.flink.table.runtime.typeutils.StringDataTypeInfo;
import org.apache.flink.table.runtime.typeutils.TimestampDataTypeInfo;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LegacyTypeInformationType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeFamily;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.LogicalTypeVisitor;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.MultisetType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.utils.LogicalTypeDefaultVisitor;

public class PlannerTypeUtils {
    public static LogicalType removeLegacyTypes(LogicalType t) {
        return (LogicalType)t.accept((LogicalTypeVisitor)new LegacyTypeToPlannerTypeConverter());
    }

    public static boolean isPrimitive(LogicalType type) {
        return PlannerTypeUtils.isPrimitive(type.getTypeRoot());
    }

    public static boolean isPrimitive(LogicalTypeRoot root) {
        switch (root) {
            case BOOLEAN: 
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case FLOAT: 
            case DOUBLE: {
                return true;
            }
        }
        return false;
    }

    public static boolean isInteroperable(LogicalType t1, LogicalType t2) {
        if (t1.getTypeRoot().getFamilies().contains(LogicalTypeFamily.CHARACTER_STRING) && t2.getTypeRoot().getFamilies().contains(LogicalTypeFamily.CHARACTER_STRING)) {
            return true;
        }
        if (t1.getTypeRoot().getFamilies().contains(LogicalTypeFamily.BINARY_STRING) && t2.getTypeRoot().getFamilies().contains(LogicalTypeFamily.BINARY_STRING)) {
            return true;
        }
        if (t1.getTypeRoot() != t2.getTypeRoot()) {
            return false;
        }
        switch (t1.getTypeRoot()) {
            case ARRAY: 
            case MAP: 
            case MULTISET: 
            case ROW: {
                List children1 = t1.getChildren();
                List children2 = t2.getChildren();
                if (children1.size() != children2.size()) {
                    return false;
                }
                for (int i = 0; i < children1.size(); ++i) {
                    if (PlannerTypeUtils.isInteroperable((LogicalType)children1.get(i), (LogicalType)children2.get(i))) continue;
                    return false;
                }
                return true;
            }
        }
        return t1.copy(true).equals((Object)t2.copy(true));
    }

    public static boolean isAssignable(LogicalType t1, LogicalType t2) {
        if (t1.getTypeRoot().getFamilies().contains(LogicalTypeFamily.CHARACTER_STRING) && t2.getTypeRoot().getFamilies().contains(LogicalTypeFamily.CHARACTER_STRING)) {
            return true;
        }
        if (t1.getTypeRoot().getFamilies().contains(LogicalTypeFamily.BINARY_STRING) && t2.getTypeRoot().getFamilies().contains(LogicalTypeFamily.BINARY_STRING)) {
            return true;
        }
        if (t1.getTypeRoot() != t2.getTypeRoot()) {
            return false;
        }
        switch (t1.getTypeRoot()) {
            case DECIMAL: 
            case TIMESTAMP_WITHOUT_TIME_ZONE: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return true;
            }
        }
        if (t1.getChildren().isEmpty()) {
            return t1.copy(true).equals((Object)t2.copy(true));
        }
        List children1 = t1.getChildren();
        List children2 = t2.getChildren();
        if (children1.size() != children2.size()) {
            return false;
        }
        for (int i = 0; i < children1.size(); ++i) {
            if (PlannerTypeUtils.isAssignable((LogicalType)children1.get(i), (LogicalType)children2.get(i))) continue;
            return false;
        }
        return true;
    }

    private static class LegacyTypeToPlannerTypeConverter
    extends LogicalTypeDefaultVisitor<LogicalType> {
        private LegacyTypeToPlannerTypeConverter() {
        }

        protected LogicalType defaultMethod(LogicalType logicalType) {
            if (logicalType instanceof LegacyTypeInformationType) {
                TypeInformation typeInfo = ((LegacyTypeInformationType)logicalType).getTypeInformation();
                if (typeInfo.equals((Object)BasicTypeInfo.BIG_DEC_TYPE_INFO)) {
                    return DecimalDataUtils.DECIMAL_SYSTEM_DEFAULT;
                }
                if (typeInfo.equals((Object)StringDataTypeInfo.INSTANCE)) {
                    return DataTypes.STRING().getLogicalType();
                }
                if (typeInfo instanceof BasicArrayTypeInfo) {
                    return new ArrayType(TypeInfoLogicalTypeConverter.fromTypeInfoToLogicalType(((BasicArrayTypeInfo)typeInfo).getComponentInfo()));
                }
                if (typeInfo instanceof CompositeType) {
                    CompositeType compositeType = (CompositeType)typeInfo;
                    return RowType.of((LogicalType[])((LogicalType[])Stream.iterate(0, x -> x + 1).limit(compositeType.getArity()).map(arg_0 -> ((CompositeType)compositeType).getTypeAt(arg_0)).map(TypeInfoLogicalTypeConverter::fromTypeInfoToLogicalType).toArray(LogicalType[]::new)), (String[])compositeType.getFieldNames());
                }
                if (typeInfo instanceof DecimalDataTypeInfo) {
                    DecimalDataTypeInfo decimalType = (DecimalDataTypeInfo)typeInfo;
                    return new DecimalType(decimalType.precision(), decimalType.scale());
                }
                if (typeInfo instanceof BigDecimalTypeInfo) {
                    BigDecimalTypeInfo decimalType = (BigDecimalTypeInfo)typeInfo;
                    return new DecimalType(decimalType.precision(), decimalType.scale());
                }
                if (typeInfo instanceof TimestampDataTypeInfo) {
                    TimestampDataTypeInfo timestampDataTypeInfo = (TimestampDataTypeInfo)typeInfo;
                    return new TimestampType(timestampDataTypeInfo.getPrecision());
                }
                if (typeInfo instanceof LegacyLocalDateTimeTypeInfo) {
                    LegacyLocalDateTimeTypeInfo dateTimeType = (LegacyLocalDateTimeTypeInfo)typeInfo;
                    return new TimestampType(dateTimeType.getPrecision());
                }
                if (typeInfo instanceof LegacyTimestampTypeInfo) {
                    LegacyTimestampTypeInfo timstampType = (LegacyTimestampTypeInfo)typeInfo;
                    return new TimestampType(timstampType.getPrecision());
                }
                if (typeInfo instanceof LegacyInstantTypeInfo) {
                    LegacyInstantTypeInfo instantTypeInfo = (LegacyInstantTypeInfo)typeInfo;
                    return new LocalZonedTimestampType(instantTypeInfo.getPrecision());
                }
                if (typeInfo instanceof InternalTypeInfo) {
                    return ((InternalTypeInfo)typeInfo).toLogicalType();
                }
                return new TypeInformationRawType(typeInfo);
            }
            return logicalType;
        }

        public LogicalType visit(ArrayType arrayType) {
            return new ArrayType(arrayType.isNullable(), (LogicalType)arrayType.getElementType().accept((LogicalTypeVisitor)this));
        }

        public LogicalType visit(MultisetType multisetType) {
            return new MultisetType(multisetType.isNullable(), (LogicalType)multisetType.getElementType().accept((LogicalTypeVisitor)this));
        }

        public LogicalType visit(MapType mapType) {
            return new MapType(mapType.isNullable(), (LogicalType)mapType.getKeyType().accept((LogicalTypeVisitor)this), (LogicalType)mapType.getValueType().accept((LogicalTypeVisitor)this));
        }

        public LogicalType visit(RowType rowType) {
            return new RowType(rowType.isNullable(), rowType.getFields().stream().map(field -> new RowType.RowField(field.getName(), (LogicalType)field.getType().accept((LogicalTypeVisitor)this))).collect(Collectors.toList()));
        }
    }
}

