/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.sink.constraint;

import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.UpdatableRowData;
import org.apache.flink.table.runtime.operators.sink.constraint.Constraint;
import org.apache.flink.table.runtime.operators.sink.constraint.EnforcerException;

@Internal
final class NestedRowConstraint
implements Constraint {
    private final int[] nestedRowFieldIndices;
    private final int[] nestedRowFieldArities;
    private final String[] nestedRowFieldNames;
    private final Constraint[][] nestedRowConstraints;

    NestedRowConstraint(int[] nestedRowFieldIndices, int[] nestedRowFieldArities, String[] nestedRowFieldNames, Constraint[][] nestedRowConstraints) {
        this.nestedRowFieldIndices = nestedRowFieldIndices;
        this.nestedRowFieldArities = nestedRowFieldArities;
        this.nestedRowFieldNames = nestedRowFieldNames;
        this.nestedRowConstraints = nestedRowConstraints;
    }

    @Override
    @Nullable
    public RowData enforce(RowData input) {
        RowData updatableRowData = null;
        for (int i = 0; i < this.nestedRowFieldIndices.length; ++i) {
            int index = this.nestedRowFieldIndices[i];
            if (input.isNullAt(index)) continue;
            RowData nestedRow = input.getRow(index, this.nestedRowFieldArities[i]);
            for (Constraint constraint : this.nestedRowConstraints[i]) {
                RowData enforcedRow = this.enforce(constraint, nestedRow, i);
                if (enforcedRow == null) {
                    return null;
                }
                if (enforcedRow == nestedRow) continue;
                if (updatableRowData == null) {
                    updatableRowData = new UpdatableRowData(input, input.getArity());
                }
                updatableRowData.setField(index, enforcedRow);
                nestedRow = enforcedRow;
            }
        }
        return updatableRowData != null ? updatableRowData : input;
    }

    private RowData enforce(Constraint constraint, RowData nestedRow, int index) {
        try {
            return constraint.enforce(nestedRow);
        }
        catch (EnforcerException e) {
            throw new EnforcerException(e.getFormat(), this.nestedRowFieldNames[index] + "." + e.getColumnName());
        }
    }

    public String toString() {
        return String.format("NestedRowEnforcer(constraints=[%s])", IntStream.range(0, this.nestedRowFieldIndices.length).mapToObj(idx -> String.format("{%s=%s}", this.nestedRowFieldNames[idx], Arrays.toString(this.nestedRowConstraints[idx]))).collect(Collectors.joining(", ")));
    }
}

