/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.sink.constraint;

import java.util.BitSet;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.UpdatableRowData;
import org.apache.flink.table.data.binary.BinaryStringData;
import org.apache.flink.table.runtime.operators.sink.constraint.Constraint;
import org.apache.flink.table.runtime.operators.sink.constraint.EnforcerException;
import org.apache.flink.table.runtime.operators.sink.constraint.TypeLengthEnforcementStrategy;
import org.apache.flink.table.runtime.util.SegmentsUtil;

@Internal
final class CharLengthConstraint
implements Constraint {
    private final TypeLengthEnforcementStrategy enforcementStrategy;
    private final int[] fieldIndices;
    private final int[] fieldLengths;
    private final String[] fieldNames;
    private final BitSet fieldCouldPad;

    CharLengthConstraint(TypeLengthEnforcementStrategy enforcementStrategy, int[] charFieldIndices, int[] charFieldLengths, String[] charFieldNames, BitSet charFieldCouldPad) {
        this.enforcementStrategy = enforcementStrategy;
        this.fieldIndices = charFieldIndices;
        this.fieldLengths = charFieldLengths;
        this.fieldNames = charFieldNames;
        this.fieldCouldPad = charFieldCouldPad;
    }

    @Override
    @Nullable
    public RowData enforce(RowData rowData) {
        RowData updatedRowData = null;
        block4: for (int i = 0; i < this.fieldIndices.length; ++i) {
            int fieldIdx = this.fieldIndices[i];
            int expectedLength = this.fieldLengths[i];
            BinaryStringData stringData = (BinaryStringData)rowData.getString(fieldIdx);
            int actualLength = stringData.numChars();
            boolean shouldPad = this.fieldCouldPad.get(i);
            switch (this.enforcementStrategy) {
                case TRIM_PAD: {
                    updatedRowData = this.trimOrPad(rowData, actualLength, expectedLength, (UpdatableRowData)updatedRowData, stringData, fieldIdx, shouldPad);
                    continue block4;
                }
                case THROW: {
                    if (actualLength <= expectedLength && (!shouldPad || actualLength >= expectedLength)) continue block4;
                    throw new EnforcerException("Column '%s'" + String.format(" is %s, however, a string of length %s is being written into it. You can set job configuration '%s' to control this behaviour.", (shouldPad ? "CHAR(" : "VARCHAR(") + expectedLength + ")", actualLength, ExecutionConfigOptions.TABLE_EXEC_SINK_TYPE_LENGTH_ENFORCER.key()), this.fieldNames[i]);
                }
            }
        }
        return updatedRowData != null ? updatedRowData : rowData;
    }

    private UpdatableRowData trimOrPad(RowData rowData, int actualLength, int expectedLength, UpdatableRowData updatedRowData, BinaryStringData stringData, int fieldIdx, boolean canPad) {
        if (canPad && actualLength < expectedLength) {
            if (updatedRowData == null) {
                updatedRowData = new UpdatableRowData(rowData, rowData.getArity());
            }
            int srcSizeInBytes = stringData.getSizeInBytes();
            byte[] newString = new byte[srcSizeInBytes + expectedLength - actualLength];
            for (int j = srcSizeInBytes; j < newString.length; ++j) {
                newString[j] = 32;
            }
            SegmentsUtil.copyToBytes(stringData.getSegments(), stringData.getOffset(), newString, 0, srcSizeInBytes);
            updatedRowData.setField(fieldIdx, StringData.fromBytes((byte[])newString));
        } else if (actualLength > expectedLength) {
            if (updatedRowData == null) {
                updatedRowData = new UpdatableRowData(rowData, rowData.getArity());
            }
            updatedRowData.setField(fieldIdx, stringData.substring(0, expectedLength));
        }
        return updatedRowData;
    }

    public String toString() {
        return String.format("LengthEnforcer(fields=[%s])", String.join((CharSequence)", ", this.fieldNames));
    }
}

