/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.rank.async;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.flink.api.common.functions.OpenContext;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.serialization.SerializerConfigImpl;
import org.apache.flink.api.common.state.StateTtlConfig;
import org.apache.flink.api.common.state.v2.MapState;
import org.apache.flink.api.common.state.v2.MapStateDescriptor;
import org.apache.flink.api.common.state.v2.StateFuture;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.ListTypeInfo;
import org.apache.flink.core.state.StateFutureUtils;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.generated.GeneratedRecordComparator;
import org.apache.flink.table.runtime.keyselector.RowDataKeySelector;
import org.apache.flink.table.runtime.operators.rank.RankRange;
import org.apache.flink.table.runtime.operators.rank.RankType;
import org.apache.flink.table.runtime.operators.rank.TopNBuffer;
import org.apache.flink.table.runtime.operators.rank.async.AbstractAsyncStateTopNFunction;
import org.apache.flink.table.runtime.operators.rank.utils.AppendOnlyTopNHelper;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.util.Collector;

public class AsyncStateAppendOnlyTopNFunction
extends AbstractAsyncStateTopNFunction {
    private static final long serialVersionUID = 1L;
    private final InternalTypeInfo<RowData> sortKeyType;
    private final TypeSerializer<RowData> inputRowSer;
    private final long cacheSize;
    private transient MapState<RowData, List<RowData>> dataState;
    private transient AsyncStateAppendOnlyTopNHelper helper;

    public AsyncStateAppendOnlyTopNFunction(StateTtlConfig ttlConfig, InternalTypeInfo<RowData> inputRowType, GeneratedRecordComparator sortKeyGeneratedRecordComparator, RowDataKeySelector sortKeySelector, RankType rankType, RankRange rankRange, boolean generateUpdateBefore, boolean outputRankNumber, long cacheSize) {
        super(ttlConfig, inputRowType, sortKeyGeneratedRecordComparator, sortKeySelector, rankType, rankRange, generateUpdateBefore, outputRankNumber);
        this.sortKeyType = sortKeySelector.getProducedType();
        this.inputRowSer = inputRowType.createSerializer((SerializerConfig)new SerializerConfigImpl());
        this.cacheSize = cacheSize;
    }

    @Override
    public void open(OpenContext openContext) throws Exception {
        super.open(openContext);
        ListTypeInfo valueTypeInfo = new ListTypeInfo((TypeInformation)this.inputRowType);
        MapStateDescriptor mapStateDescriptor = new MapStateDescriptor("data-state-with-append", this.sortKeyType, (TypeInformation)valueTypeInfo);
        if (this.ttlConfig.isEnabled()) {
            mapStateDescriptor.enableTimeToLive(this.ttlConfig);
        }
        this.dataState = this.getRuntimeContext().getMapState(mapStateDescriptor);
        this.helper = new AsyncStateAppendOnlyTopNHelper();
        this.helper.registerMetric();
    }

    public void processElement(RowData input, KeyedProcessFunction.Context context, Collector<RowData> out) throws Exception {
        StateFuture<TopNBuffer> topNBufferFuture = this.initHeapStates();
        StateFuture<Long> rankEndFuture = this.initRankEnd(input);
        RowData sortKey = (RowData)this.sortKeySelector.getKey((Object)input);
        topNBufferFuture.thenCombine(rankEndFuture, (buffer, rankEnd) -> {
            if (this.checkSortKeyInBufferRange(sortKey, (TopNBuffer)buffer)) {
                buffer.put(sortKey, (RowData)this.inputRowSer.copy((Object)input));
                Collection<RowData> inputs = buffer.get(sortKey);
                this.dataState.asyncPut((Object)sortKey, new ArrayList<RowData>(inputs)).thenAccept(VOID -> {
                    if (this.outputRankNumber || this.hasOffset()) {
                        this.helper.processElementWithRowNumber((TopNBuffer)buffer, sortKey, input, (long)rankEnd, out);
                    } else {
                        this.helper.processElementWithoutRowNumber((TopNBuffer)buffer, input, (long)rankEnd, out);
                    }
                });
            }
            return null;
        });
    }

    private StateFuture<TopNBuffer> initHeapStates() {
        this.helper.accRequestCount();
        RowData currentKey = (RowData)this.keyContext.getCurrentKey();
        TopNBuffer bufferFromCache = this.helper.getTopNBufferFromCache(currentKey);
        if (bufferFromCache != null) {
            this.helper.accHitCount();
            return StateFutureUtils.completedFuture((Object)bufferFromCache);
        }
        TopNBuffer bufferFromState = new TopNBuffer(this.sortKeyComparator, ArrayList::new);
        return this.dataState.asyncEntries().thenCompose(iter -> iter.onNext(entry -> {
            RowData sortKey = (RowData)entry.getKey();
            List values = (List)entry.getValue();
            bufferFromState.putAll(sortKey, values);
        })).thenApply(VOID -> {
            this.helper.saveTopNBufferToCache(currentKey, bufferFromState);
            return bufferFromState;
        });
    }

    private class AsyncStateAppendOnlyTopNHelper
    extends AppendOnlyTopNHelper {
        public AsyncStateAppendOnlyTopNHelper() {
            super(AsyncStateAppendOnlyTopNFunction.this, AsyncStateAppendOnlyTopNFunction.this.cacheSize, AsyncStateAppendOnlyTopNFunction.this.getDefaultTopNSize());
        }

        @Override
        protected void removeFromState(RowData key) throws Exception {
            AsyncStateAppendOnlyTopNFunction.this.dataState.asyncRemove((Object)key);
        }

        @Override
        protected void updateState(RowData key, List<RowData> value) throws Exception {
            AsyncStateAppendOnlyTopNFunction.this.dataState.asyncPut((Object)key, value);
        }
    }
}

