/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.process;

import java.util.ArrayList;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.runtime.state.VoidNamespace;
import org.apache.flink.streaming.api.operators.InternalTimerService;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.runtime.operators.process.ReadableInternalTimeContext;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.Preconditions;

@Internal
class WritableInternalTimeContext
extends ReadableInternalTimeContext {
    private final MapState<StringData, Long> namedTimersMapState;
    private final InternalTimerService<StringData> namedTimerService;
    private final InternalTimerService<VoidNamespace> unnamedTimerService;

    WritableInternalTimeContext(MapState<StringData, Long> namedTimersMapState, InternalTimerService<StringData> namedTimerService, InternalTimerService<VoidNamespace> unnamedTimerService) {
        this.namedTimersMapState = namedTimersMapState;
        this.namedTimerService = namedTimerService;
        this.unnamedTimerService = unnamedTimerService;
    }

    @Override
    public Long currentWatermark() {
        long currentWatermark = this.unnamedTimerService.currentWatermark();
        if (currentWatermark == Long.MIN_VALUE) {
            return null;
        }
        return currentWatermark;
    }

    @Override
    public void registerOnTime(String name, Long time) {
        this.registerOnTimeInternal(name, time);
    }

    @Override
    public void registerOnTime(Long time) {
        this.registerOnTimeInternal(null, time);
    }

    @Override
    public void clearTimer(String name) {
        Preconditions.checkNotNull((Object)name, (String)"Timer name must not be null.");
        this.deleteTimerInternal(name);
    }

    @Override
    public void clearTimer(Long time) {
        this.deleteTimerInternal(time);
    }

    @Override
    public void clearAllTimers() {
        this.clearUnnamedTimers();
        this.clearNamedTimers();
    }

    private void registerOnTimeInternal(@Nullable String name, long newTime) {
        if (newTime <= this.unnamedTimerService.currentWatermark()) {
            return;
        }
        if (name != null) {
            this.replaceNamedTimer(StringData.fromString((String)name), newTime);
        } else {
            this.registerUnnamedTimer(newTime);
        }
    }

    protected void deleteTimerInternal(long time) {
        this.deleteUnnamedTimer(time);
    }

    private void registerUnnamedTimer(long time) {
        this.unnamedTimerService.registerEventTimeTimer((Object)VoidNamespace.INSTANCE, time);
    }

    private void deleteUnnamedTimer(long time) {
        this.unnamedTimerService.deleteEventTimeTimer((Object)VoidNamespace.INSTANCE, time);
    }

    private void clearUnnamedTimers() {
        ArrayList unnamedTimers = new ArrayList();
        try {
            this.unnamedTimerService.forEachEventTimeTimer((namespace, time) -> unnamedTimers.add(time));
        }
        catch (Exception e) {
            throw new FlinkRuntimeException((Throwable)e);
        }
        unnamedTimers.forEach(time -> this.unnamedTimerService.deleteEventTimeTimer((Object)VoidNamespace.INSTANCE, time.longValue()));
    }

    private void deleteTimerInternal(String name) {
        this.deleteNamedTimer(StringData.fromString((String)name));
    }

    private void replaceNamedTimer(StringData internalName, long newTime) {
        Long existingTime;
        try {
            existingTime = (Long)this.namedTimersMapState.get((Object)internalName);
        }
        catch (Exception e) {
            throw new FlinkRuntimeException((Throwable)e);
        }
        if (existingTime != null) {
            this.namedTimerService.deleteEventTimeTimer((Object)internalName, existingTime.longValue());
        }
        this.registerNamedTimer(internalName, newTime);
    }

    private void registerNamedTimer(StringData internalName, long newTime) {
        try {
            this.namedTimersMapState.put((Object)internalName, (Object)newTime);
        }
        catch (Exception e) {
            throw new FlinkRuntimeException((Throwable)e);
        }
        this.namedTimerService.registerEventTimeTimer((Object)internalName, newTime);
    }

    private void deleteNamedTimer(StringData internalName) {
        Long existingTime;
        try {
            existingTime = (Long)this.namedTimersMapState.get((Object)internalName);
        }
        catch (Exception e) {
            throw new FlinkRuntimeException((Throwable)e);
        }
        if (existingTime != null) {
            this.namedTimerService.deleteEventTimeTimer((Object)internalName, existingTime.longValue());
            try {
                this.namedTimersMapState.remove((Object)internalName);
            }
            catch (Exception e) {
                throw new FlinkRuntimeException((Throwable)e);
            }
        }
    }

    private void clearNamedTimers() {
        Iterable entries;
        try {
            entries = this.namedTimersMapState.entries();
        }
        catch (Exception e2) {
            throw new FlinkRuntimeException((Throwable)e2);
        }
        entries.forEach(e -> this.namedTimerService.deleteEventTimeTimer((Object)((StringData)e.getKey()), ((Long)e.getValue()).longValue()));
        this.namedTimersMapState.clear();
    }
}

