/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.calc.async;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import org.apache.flink.streaming.api.functions.async.ResultFuture;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.conversion.DataStructureConverter;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Preconditions;

public class DelegatingAsyncResultFuture
implements BiConsumer<Object, Throwable> {
    private final ResultFuture<Object> delegatedResultFuture;
    private final int totalResultSize;
    private final Map<Integer, Object> synchronousIndexToResults = new HashMap<Integer, Object>();
    private CompletableFuture<Object> future;
    private DataStructureConverter<Object, Object> converter;
    private int asyncIndex = -1;
    private RowKind rowKind;

    public DelegatingAsyncResultFuture(ResultFuture<Object> delegatedResultFuture, int totalResultSize) {
        this.delegatedResultFuture = delegatedResultFuture;
        this.totalResultSize = totalResultSize;
    }

    public synchronized void setRowKind(RowKind rowKind) {
        this.rowKind = rowKind;
    }

    public synchronized void addSynchronousResult(int resultIndex, Object object) {
        this.synchronousIndexToResults.put(resultIndex, object);
    }

    public synchronized void addAsyncIndex(int resultIndex) {
        Preconditions.checkState((this.asyncIndex == -1 ? 1 : 0) != 0);
        this.asyncIndex = resultIndex;
    }

    public CompletableFuture<?> createAsyncFuture(DataStructureConverter<Object, Object> converter) {
        Preconditions.checkState((this.future == null ? 1 : 0) != 0);
        Preconditions.checkState((this.converter == null ? 1 : 0) != 0);
        Preconditions.checkState((this.asyncIndex >= 0 ? 1 : 0) != 0);
        this.future = new CompletableFuture();
        this.converter = converter;
        this.future.whenComplete((BiConsumer)this);
        return this.future;
    }

    @Override
    public void accept(Object o, Throwable throwable) {
        if (throwable != null) {
            this.delegatedResultFuture.completeExceptionally(throwable);
        } else {
            try {
                this.delegatedResultFuture.complete(() -> {
                    Object converted = this.converter.toInternal(o);
                    return Collections.singleton(this.createResult(converted));
                });
            }
            catch (Throwable t) {
                this.delegatedResultFuture.completeExceptionally(t);
            }
        }
    }

    private RowData createResult(Object asyncResult) {
        GenericRowData result = new GenericRowData(this.totalResultSize);
        if (this.rowKind != null) {
            result.setRowKind(this.rowKind);
        }
        for (Map.Entry<Integer, Object> entry : this.synchronousIndexToResults.entrySet()) {
            result.setField(entry.getKey().intValue(), entry.getValue());
        }
        result.setField(this.asyncIndex, asyncResult);
        return result;
    }
}

