/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.generated;

import java.io.IOException;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.functions.AbstractRichFunction;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.runtime.generated.HashFunction;
import org.apache.flink.table.runtime.generated.RecordEqualiser;
import org.apache.flink.table.runtime.operators.process.AbstractProcessTableOperator;
import org.apache.flink.table.runtime.operators.process.PassAllCollector;
import org.apache.flink.table.runtime.operators.process.PassThroughCollectorBase;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.function.RunnableWithException;

@Internal
public abstract class ProcessTableRunner
extends AbstractRichFunction {
    protected State[] stateHandles;
    private HashFunction[] stateHashCode;
    private RecordEqualiser[] stateEquals;
    private boolean emitRowtime;
    protected AbstractProcessTableOperator.RunnerContext runnerContext;
    protected AbstractProcessTableOperator.RunnerOnTimerContext runnerOnTimerContext;
    protected PassThroughCollectorBase evalCollector;
    protected PassAllCollector onTimerCollector;
    protected int inputIndex = -1;
    protected RowData inputRow;
    private long currentWatermark = Long.MIN_VALUE;
    @Nullable
    private Long rowtime;
    @Nullable
    private StringData timerName;
    protected RowData[] valueStateToFunction;
    protected boolean[] stateCleared;
    protected RowData[] valueStateFromFunction;

    public void initialize(State[] stateHandles, HashFunction[] stateHashCode, RecordEqualiser[] stateEquals, boolean emitRowtime, AbstractProcessTableOperator.RunnerContext runnerContext, AbstractProcessTableOperator.RunnerOnTimerContext runnerOnTimerContext, PassThroughCollectorBase evalCollector, PassAllCollector onTimerCollector) {
        this.stateHandles = stateHandles;
        this.stateHashCode = stateHashCode;
        this.stateEquals = stateEquals;
        this.emitRowtime = emitRowtime;
        this.runnerContext = runnerContext;
        this.runnerOnTimerContext = runnerOnTimerContext;
        this.evalCollector = evalCollector;
        this.onTimerCollector = onTimerCollector;
        this.valueStateToFunction = new RowData[stateHandles.length];
        this.stateCleared = new boolean[stateHandles.length];
        this.valueStateFromFunction = new RowData[stateHandles.length];
    }

    public void ingestTableEvent(int pos, RowData row, int timeColumn) {
        this.evalCollector.setPrefix(pos, row);
        if (timeColumn == -1) {
            this.rowtime = null;
        } else {
            long inputTime = row.getTimestamp(timeColumn, 3).getMillisecond();
            if (this.emitRowtime) {
                this.evalCollector.setRowtime(inputTime);
            }
            this.rowtime = inputTime;
        }
        this.inputIndex = pos;
        this.inputRow = row;
    }

    public void ingestTimerEvent(RowData key, @Nullable StringData name, long timerTime) {
        this.onTimerCollector.setPrefix(-1, key);
        if (this.emitRowtime) {
            this.onTimerCollector.setRowtime(timerTime);
        }
        this.rowtime = timerTime;
        this.timerName = name;
    }

    public void ingestWatermarkEvent(long watermarkTime) {
        this.currentWatermark = watermarkTime;
    }

    public void clearAllState() {
        Arrays.fill(this.stateCleared, true);
    }

    public void clearState(int statePos) {
        this.stateCleared[statePos] = true;
    }

    public long getCurrentWatermark() {
        return this.currentWatermark;
    }

    @Nullable
    public Long getTime() {
        return this.rowtime;
    }

    @Nullable
    public StringData getTimerName() {
        return this.timerName;
    }

    public void processEval() throws Exception {
        if (this.rowtime != null && this.rowtime <= this.currentWatermark) {
            return;
        }
        this.processMethod(this::callEval);
    }

    public void processOnTimer() throws Exception {
        this.processMethod(this::callOnTimer);
    }

    public abstract void callEval() throws Exception;

    public abstract void callOnTimer() throws Exception;

    private void processMethod(RunnableWithException method) throws Exception {
        if (this.stateHandles.length > 0) {
            this.moveStateToFunction();
            method.run();
            this.moveStateFromFunction();
        } else {
            method.run();
        }
    }

    private void moveStateToFunction() throws IOException {
        Arrays.fill(this.stateCleared, false);
        for (int i = 0; i < this.stateHandles.length; ++i) {
            RowData value;
            State stateHandle = this.stateHandles[i];
            if (!(stateHandle instanceof ValueState)) continue;
            ValueState valueState = (ValueState)stateHandle;
            this.valueStateToFunction[i] = value = (RowData)valueState.value();
        }
    }

    private void moveStateFromFunction() throws IOException {
        for (int i = 0; i < this.stateHandles.length; ++i) {
            State stateHandle = this.stateHandles[i];
            if (stateHandle instanceof ValueState) {
                this.moveValueStateFromFunction((ValueState<RowData>)((ValueState)stateHandle), i);
                continue;
            }
            if (!this.stateCleared[i]) continue;
            stateHandle.clear();
        }
    }

    private void moveValueStateFromFunction(ValueState<RowData> valueState, int pos) throws IOException {
        RowData fromFunction = this.valueStateFromFunction[pos];
        if (fromFunction == null || ProcessTableRunner.isEmpty(fromFunction)) {
            valueState.clear();
        } else {
            HashFunction hashCode = this.stateHashCode[pos];
            RecordEqualiser equals = this.stateEquals[pos];
            RowData toFunction = this.valueStateToFunction[pos];
            if (toFunction == null || hashCode.hashCode(toFunction) != hashCode.hashCode(fromFunction) || !equals.equals(toFunction, fromFunction)) {
                valueState.update((Object)fromFunction);
            }
        }
    }

    private static boolean isEmpty(RowData row) {
        for (int i = 0; i < row.getArity(); ++i) {
            if (row.isNullAt(i)) continue;
            return false;
        }
        return row.getRowKind() == RowKind.INSERT;
    }
}

