/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cep.nfa.sharedbuffer;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.cep.nfa.DeweyNumber;
import org.apache.flink.cep.nfa.compiler.NFAStateNameHandler;
import org.apache.flink.cep.nfa.sharedbuffer.EventId;
import org.apache.flink.cep.nfa.sharedbuffer.Lockable;
import org.apache.flink.cep.nfa.sharedbuffer.NodeId;
import org.apache.flink.cep.nfa.sharedbuffer.SharedBuffer;
import org.apache.flink.cep.nfa.sharedbuffer.SharedBufferEdge;
import org.apache.flink.cep.nfa.sharedbuffer.SharedBufferNode;
import org.apache.flink.util.CollectionUtil;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.WrappingRuntimeException;

public class SharedBufferAccessor<V>
implements AutoCloseable {
    private SharedBuffer<V> sharedBuffer;

    SharedBufferAccessor(SharedBuffer<V> sharedBuffer) {
        this.sharedBuffer = sharedBuffer;
    }

    public void advanceTime(long timestamp) throws Exception {
        this.sharedBuffer.advanceTime(timestamp);
    }

    public EventId registerEvent(V value, long timestamp) throws Exception {
        return this.sharedBuffer.registerEvent(value, timestamp);
    }

    public NodeId put(String stateName, EventId eventId, @Nullable NodeId previousNodeId, DeweyNumber version) {
        NodeId currentNodeId;
        Lockable<SharedBufferNode> currentNode;
        if (previousNodeId != null) {
            this.lockNode(previousNodeId, version);
        }
        if ((currentNode = this.sharedBuffer.getEntry(currentNodeId = new NodeId(eventId, NFAStateNameHandler.getOriginalNameFromInternal(stateName)))) == null) {
            currentNode = new Lockable<SharedBufferNode>(new SharedBufferNode(), 0);
            this.lockEvent(eventId);
        }
        currentNode.getElement().addEdge(new SharedBufferEdge(previousNodeId, version));
        this.sharedBuffer.upsertEntry(currentNodeId, currentNode);
        return currentNodeId;
    }

    public List<Map<String, List<EventId>>> extractPatterns(NodeId nodeId, DeweyNumber version) {
        ArrayList<Map<String, List<EventId>>> result = new ArrayList<Map<String, List<EventId>>>();
        Stack<ExtractionState> extractionStates = new Stack<ExtractionState>();
        Lockable<SharedBufferNode> entryLock = this.sharedBuffer.getEntry(nodeId);
        if (entryLock != null) {
            SharedBufferNode entry = entryLock.getElement();
            extractionStates.add(new ExtractionState((Tuple2<NodeId, SharedBufferNode>)Tuple2.of((Object)nodeId, (Object)entry), version, new Stack<Tuple2<NodeId, SharedBufferNode>>()));
            while (!extractionStates.isEmpty()) {
                ExtractionState extractionState = (ExtractionState)extractionStates.pop();
                Stack<Tuple2<NodeId, SharedBufferNode>> currentPath = extractionState.getPath();
                Tuple2<NodeId, SharedBufferNode> currentEntry = extractionState.getEntry();
                if (currentEntry == null) {
                    LinkedHashMap<String, List> completePath = new LinkedHashMap<String, List>();
                    while (!currentPath.isEmpty()) {
                        NodeId currentPathEntry = (NodeId)currentPath.pop().f0;
                        String page = currentPathEntry.getPageName();
                        List values = completePath.computeIfAbsent(page, k -> new ArrayList());
                        values.add(currentPathEntry.getEventId());
                    }
                    result.add(completePath);
                    continue;
                }
                currentPath.push(currentEntry);
                boolean firstMatch = true;
                for (Lockable<SharedBufferEdge> lockableEdge : ((SharedBufferNode)currentEntry.f1).getEdges()) {
                    Stack<Object> newPath;
                    SharedBufferEdge edge = lockableEdge.getElement();
                    DeweyNumber currentVersion = extractionState.getVersion();
                    if (!currentVersion.isCompatibleWith(edge.getDeweyNumber())) continue;
                    NodeId target = edge.getTarget();
                    if (firstMatch) {
                        newPath = currentPath;
                        firstMatch = false;
                    } else {
                        newPath = new Stack();
                        newPath.addAll(currentPath);
                    }
                    extractionStates.push(new ExtractionState(target != null ? Tuple2.of((Object)target, (Object)this.sharedBuffer.getEntry(target).getElement()) : null, edge.getDeweyNumber(), newPath));
                }
            }
        }
        return result;
    }

    public Map<String, List<V>> materializeMatch(Map<String, List<EventId>> match) {
        LinkedHashMap materializedMatch = CollectionUtil.newLinkedHashMapWithExpectedSize((int)match.size());
        for (Map.Entry<String, List<EventId>> pattern : match.entrySet()) {
            ArrayList<V> events = new ArrayList<V>(pattern.getValue().size());
            for (EventId eventId : pattern.getValue()) {
                try {
                    V event = this.sharedBuffer.getEvent(eventId).getElement();
                    events.add(event);
                }
                catch (Exception ex) {
                    throw new WrappingRuntimeException((Throwable)ex);
                }
            }
            materializedMatch.put(pattern.getKey(), events);
        }
        return materializedMatch;
    }

    public void lockNode(NodeId node, DeweyNumber version) {
        Lockable<SharedBufferNode> sharedBufferNode = this.sharedBuffer.getEntry(node);
        if (sharedBufferNode != null) {
            sharedBufferNode.lock();
            for (Lockable<SharedBufferEdge> edge : sharedBufferNode.getElement().getEdges()) {
                if (!version.isCompatibleWith(edge.getElement().getDeweyNumber())) continue;
                edge.lock();
            }
            this.sharedBuffer.upsertEntry(node, sharedBufferNode);
        }
    }

    public void releaseNode(NodeId node, DeweyNumber version) throws Exception {
        NodeId curNode;
        Lockable<SharedBufferNode> curBufferNode;
        Stack<NodeId> nodesToExamine = new Stack<NodeId>();
        Stack<DeweyNumber> versionsToExamine = new Stack<DeweyNumber>();
        nodesToExamine.push(node);
        versionsToExamine.push(version);
        while (!nodesToExamine.isEmpty() && (curBufferNode = this.sharedBuffer.getEntry(curNode = (NodeId)nodesToExamine.pop())) != null) {
            DeweyNumber currentVersion = (DeweyNumber)versionsToExamine.pop();
            List<Lockable<SharedBufferEdge>> edges = curBufferNode.getElement().getEdges();
            Iterator<Lockable<SharedBufferEdge>> edgesIterator = edges.iterator();
            while (edgesIterator.hasNext()) {
                Lockable<SharedBufferEdge> sharedBufferEdge = edgesIterator.next();
                SharedBufferEdge edge = sharedBufferEdge.getElement();
                if (!currentVersion.isCompatibleWith(edge.getDeweyNumber()) || !sharedBufferEdge.release()) continue;
                edgesIterator.remove();
                NodeId targetId = edge.getTarget();
                if (targetId == null) continue;
                nodesToExamine.push(targetId);
                versionsToExamine.push(edge.getDeweyNumber());
            }
            if (curBufferNode.release()) {
                this.sharedBuffer.removeEntry(curNode);
                this.releaseEvent(curNode.getEventId());
                continue;
            }
            this.sharedBuffer.upsertEntry(curNode, curBufferNode);
        }
    }

    private void lockEvent(EventId eventId) {
        Lockable<V> eventWrapper = this.sharedBuffer.getEvent(eventId);
        Preconditions.checkState((eventWrapper != null ? 1 : 0) != 0, (String)"Referring to non existent event with id %s", (Object[])new Object[]{eventId});
        eventWrapper.lock();
        this.sharedBuffer.upsertEvent(eventId, eventWrapper);
    }

    public void releaseEvent(EventId eventId) throws Exception {
        Lockable<V> eventWrapper = this.sharedBuffer.getEvent(eventId);
        if (eventWrapper != null) {
            if (eventWrapper.release()) {
                this.sharedBuffer.removeEvent(eventId);
            } else {
                this.sharedBuffer.upsertEvent(eventId, eventWrapper);
            }
        }
    }

    @Override
    public void close() throws Exception {
        this.sharedBuffer.flushCache();
    }

    private static class ExtractionState {
        private final Tuple2<NodeId, SharedBufferNode> entry;
        private final DeweyNumber version;
        private final Stack<Tuple2<NodeId, SharedBufferNode>> path;

        ExtractionState(Tuple2<NodeId, SharedBufferNode> entry, DeweyNumber version, Stack<Tuple2<NodeId, SharedBufferNode>> path) {
            this.entry = entry;
            this.version = version;
            this.path = path;
        }

        public Tuple2<NodeId, SharedBufferNode> getEntry() {
            return this.entry;
        }

        public Stack<Tuple2<NodeId, SharedBufferNode>> getPath() {
            return this.path;
        }

        public DeweyNumber getVersion() {
            return this.version;
        }

        public String toString() {
            return "ExtractionState(" + String.valueOf(this.entry) + ", " + String.valueOf(this.version) + ", [" + StringUtils.join(this.path, (String)", ") + "])";
        }
    }
}

