/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.src.enumerate;

import java.io.IOException;
import java.util.ArrayList;
import java.util.function.Predicate;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.file.src.FileSourceSplit;
import org.apache.flink.connector.file.src.enumerate.DefaultFileFilter;
import org.apache.flink.connector.file.src.enumerate.NonSplittingRecursiveEnumerator;
import org.apache.flink.connector.file.src.enumerate.RegexFileFilter;
import org.apache.flink.core.fs.FileStatus;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;

@Internal
public class NonSplittingRecursiveAllDirEnumerator
extends NonSplittingRecursiveEnumerator {
    private final DefaultFileFilter hiddenDirFilter = new DefaultFileFilter();

    public NonSplittingRecursiveAllDirEnumerator(String pathRegexPattern) {
        this(new RegexFileFilter(pathRegexPattern));
    }

    public NonSplittingRecursiveAllDirEnumerator(Predicate<Path> fileFilter) {
        super(fileFilter);
    }

    @Override
    protected void addSplitsForPath(FileStatus fileStatus, FileSystem fs, ArrayList<FileSourceSplit> target) throws IOException {
        if (fileStatus.isDir()) {
            FileStatus[] containedFiles;
            if (!this.hiddenDirFilter.test(fileStatus.getPath())) {
                return;
            }
            for (FileStatus containedStatus : containedFiles = fs.listStatus(fileStatus.getPath())) {
                this.addSplitsForPath(containedStatus, fs, target);
            }
        } else if (this.fileFilter.test(fileStatus.getPath())) {
            this.convertToSourceSplits(fileStatus, fs, target);
            return;
        }
    }
}

