/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.externalresource.gpu;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.apache.flink.api.common.externalresource.ExternalResourceInfo;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;

public class GPUInfo
implements ExternalResourceInfo {
    private static final String PROPERTY_KEY_INDEX = "index";
    private final String index;

    GPUInfo(String index) {
        Preconditions.checkArgument((!StringUtils.isNullOrWhitespaceOnly((String)index) ? 1 : 0) != 0);
        this.index = index;
    }

    public String toString() {
        return String.format("GPU Device(%s)", this.index);
    }

    public int hashCode() {
        return this.index.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof GPUInfo) {
            GPUInfo other = (GPUInfo)obj;
            return this.index.equals(other.index);
        }
        return false;
    }

    public Optional<String> getProperty(String key) {
        if (key.equals(PROPERTY_KEY_INDEX)) {
            return Optional.of(this.index);
        }
        return Optional.empty();
    }

    public Collection<String> getKeys() {
        return Collections.singleton(PROPERTY_KEY_INDEX);
    }
}

