/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.metrics.datadog;

import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.flink.metrics.CharacterFilter;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.Histogram;
import org.apache.flink.metrics.LogicalScopeProvider;
import org.apache.flink.metrics.Meter;
import org.apache.flink.metrics.Metric;
import org.apache.flink.metrics.MetricConfig;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.datadog.Clock;
import org.apache.flink.metrics.datadog.DCounter;
import org.apache.flink.metrics.datadog.DGauge;
import org.apache.flink.metrics.datadog.DHistogram;
import org.apache.flink.metrics.datadog.DMeter;
import org.apache.flink.metrics.datadog.DMetric;
import org.apache.flink.metrics.datadog.DSeries;
import org.apache.flink.metrics.datadog.DataCenter;
import org.apache.flink.metrics.datadog.DatadogHttpClient;
import org.apache.flink.metrics.reporter.MetricReporter;
import org.apache.flink.metrics.reporter.Scheduled;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatadogHttpReporter
implements MetricReporter,
Scheduled {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatadogHttpReporter.class);
    private static final String HOST_VARIABLE = "<host>";
    private final Map<Gauge, DGauge> gauges = new ConcurrentHashMap<Gauge, DGauge>();
    private final Map<Counter, DCounter> counters = new ConcurrentHashMap<Counter, DCounter>();
    private final Map<Meter, DMeter> meters = new ConcurrentHashMap<Meter, DMeter>();
    private final Map<Histogram, DHistogram> histograms = new ConcurrentHashMap<Histogram, DHistogram>();
    private final DatadogHttpClient client;
    private final List<String> configTags;
    private final int maxMetricsPerRequestValue;
    private final boolean useLogicalIdentifier;
    private final Clock clock = () -> System.currentTimeMillis() / 1000L;

    public DatadogHttpReporter(String apiKey, String proxyHost, int proxyPort, int maxMetricsPerRequestValue, DataCenter dataCenter, String tags, boolean useLogicalIdentifier) {
        this.maxMetricsPerRequestValue = maxMetricsPerRequestValue;
        this.useLogicalIdentifier = useLogicalIdentifier;
        this.client = new DatadogHttpClient(apiKey, proxyHost, proxyPort, dataCenter, true);
        this.configTags = this.getTagsFromConfig(tags);
        LOGGER.info("Configured DatadogHttpReporter with {tags={}, proxyHost={}, proxyPort={}, dataCenter={}, maxMetricsPerRequest={}", new Object[]{tags, proxyHost, proxyPort, dataCenter, maxMetricsPerRequestValue});
    }

    public void notifyOfAddedMetric(Metric metric, String metricName, MetricGroup group) {
        String name = this.useLogicalIdentifier ? "flink." + ((LogicalScopeProvider)group).getLogicalScope(CharacterFilter.NO_OP_FILTER) + "." + metricName : group.getMetricIdentifier(metricName);
        ArrayList<String> tags = new ArrayList<String>(this.configTags);
        tags.addAll(this.getTagsFromMetricGroup(group));
        String host = this.getHostFromMetricGroup(group);
        switch (metric.getMetricType()) {
            case COUNTER: {
                Counter c = (Counter)metric;
                this.counters.put(c, new DCounter(c, name, host, tags, this.clock));
                break;
            }
            case GAUGE: {
                Gauge g = (Gauge)metric;
                this.gauges.put(g, new DGauge((Gauge<Number>)g, name, host, tags, this.clock));
                break;
            }
            case METER: {
                Meter m = (Meter)metric;
                this.meters.put(m, new DMeter(m, name, host, tags, this.clock));
                break;
            }
            case HISTOGRAM: {
                Histogram h = (Histogram)metric;
                this.histograms.put(h, new DHistogram(h, name, host, tags, this.clock));
                break;
            }
            default: {
                LOGGER.warn("Cannot add unknown metric type {}. This indicates that the reporter does not support this metric type.", (Object)metric.getClass().getName());
            }
        }
    }

    public void notifyOfRemovedMetric(Metric metric, String metricName, MetricGroup group) {
        switch (metric.getMetricType()) {
            case COUNTER: {
                this.counters.remove(metric);
                break;
            }
            case GAUGE: {
                this.gauges.remove(metric);
                break;
            }
            case METER: {
                this.meters.remove(metric);
                break;
            }
            case HISTOGRAM: {
                this.histograms.remove(metric);
                break;
            }
            default: {
                LOGGER.warn("Cannot remove unknown metric type {}. This indicates that the reporter does not support this metric type.", (Object)metric.getClass().getName());
            }
        }
    }

    public void open(MetricConfig config) {
    }

    public void close() {
        this.client.close();
        LOGGER.info("Shut down DatadogHttpReporter");
    }

    public void report() {
        DSeries request = new DSeries();
        this.addGaugesAndUnregisterOnException(request);
        this.counters.values().forEach(request::add);
        this.meters.values().forEach(request::add);
        this.histograms.values().forEach(histogram -> histogram.addTo(request));
        int totalMetrics = request.getSeries().size();
        int fromIndex = 0;
        while (fromIndex < totalMetrics) {
            int toIndex = Math.min(fromIndex + this.maxMetricsPerRequestValue, totalMetrics);
            try {
                DSeries chunk = new DSeries(request.getSeries().subList(fromIndex, toIndex));
                this.client.send(chunk);
                chunk.getSeries().forEach(DMetric::ackReport);
                LOGGER.debug("Reported series with size {}.", (Object)chunk.getSeries().size());
            }
            catch (SocketTimeoutException e) {
                LOGGER.warn("Failed reporting metrics to Datadog because of socket timeout: {}", (Object)e.getMessage());
            }
            catch (Exception e) {
                LOGGER.warn("Failed reporting metrics to Datadog.", (Throwable)e);
            }
            fromIndex = toIndex;
        }
    }

    private void addGaugesAndUnregisterOnException(DSeries request) {
        ArrayList<Gauge> gaugesToRemove = new ArrayList<Gauge>();
        for (Map.Entry<Gauge, DGauge> entry : this.gauges.entrySet()) {
            DGauge g = entry.getValue();
            try {
                g.getMetricValue();
                request.add(g);
            }
            catch (ClassCastException e) {
                LOGGER.info("The metric {} will not be reported because only number types are supported by this reporter.", (Object)g.getMetricName());
                gaugesToRemove.add(entry.getKey());
            }
            catch (Exception e) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("The metric {} will not be reported because it threw an exception.", (Object)g.getMetricName(), (Object)e);
                } else {
                    LOGGER.info("The metric {} will not be reported because it threw an exception.", (Object)g.getMetricName());
                }
                gaugesToRemove.add(entry.getKey());
            }
        }
        gaugesToRemove.forEach(this.gauges::remove);
    }

    private List<String> getTagsFromConfig(String str) {
        return Arrays.asList(str.split(","));
    }

    private List<String> getTagsFromMetricGroup(MetricGroup metricGroup) {
        ArrayList<String> tags = new ArrayList<String>();
        for (Map.Entry entry : metricGroup.getAllVariables().entrySet()) {
            if (((String)entry.getKey()).equals(HOST_VARIABLE)) continue;
            tags.add(this.getVariableName((String)entry.getKey()) + ":" + (String)entry.getValue());
        }
        return tags;
    }

    private String getHostFromMetricGroup(MetricGroup metricGroup) {
        return (String)metricGroup.getAllVariables().get(HOST_VARIABLE);
    }

    private String getVariableName(String str) {
        return str.substring(1, str.length() - 1);
    }
}

