/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.syntaxCheckers;

import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.schema.SyntaxChecker;
import org.apache.directory.api.util.Strings;

public final class DerefAliasSyntaxChecker
extends SyntaxChecker {
    public static final DerefAliasSyntaxChecker INSTANCE = new DerefAliasSyntaxChecker("1.3.6.1.4.1.18060.0.4.1.0.11");

    private DerefAliasSyntaxChecker(String oid) {
        super(oid);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public boolean isValidSyntax(Object value) {
        if (value == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err((I18n)I18n.ERR_13210_SYNTAX_INVALID, (Object[])new Object[]{"null"}));
            }
            return false;
        }
        String strValue = value instanceof String ? (String)value : (value instanceof byte[] ? Strings.utf8ToString((byte[])((byte[])value)) : value.toString());
        strValue = Strings.trim((String)Strings.toLowerCaseAscii((String)strValue));
        return "never".equals(strValue) || "finding".equals(strValue) || "searching".equals(strValue) || "always".equals(strValue);
    }

    public static final class Builder
    extends SyntaxChecker.SCBuilder<DerefAliasSyntaxChecker> {
        private Builder() {
            super("1.3.6.1.4.1.18060.0.4.1.0.11");
        }

        @Override
        public DerefAliasSyntaxChecker build() {
            return new DerefAliasSyntaxChecker(this.oid);
        }
    }
}

