/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator;

import java.io.IOException;
import java.util.Locale;
import org.apache.commons.validator.AbstractCommonTest;
import org.apache.commons.validator.Validator;
import org.apache.commons.validator.ValidatorException;
import org.apache.commons.validator.ValidatorResult;
import org.apache.commons.validator.ValidatorResults;
import org.apache.commons.validator.ValueBean;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.xml.sax.SAXException;

class DateTest
extends AbstractCommonTest {
    protected static final String FORM_KEY = "dateForm";
    protected static final String ACTION = "date";

    DateTest() {
    }

    @BeforeEach
    protected void setUp() throws IOException, SAXException {
        this.loadResources("DateTest-config.xml");
    }

    @Test
    void testInvalidDate() throws ValidatorException {
        ValueBean info = new ValueBean();
        info.setValue("12/01as/2005");
        this.valueTest(info, false);
    }

    @Test
    void testValidDate() throws ValidatorException {
        ValueBean info = new ValueBean();
        info.setValue("12/01/2005");
        this.valueTest(info, true);
    }

    protected void valueTest(Object info, boolean passed) throws ValidatorException {
        Validator validator = new Validator(this.resources, FORM_KEY);
        validator.setParameter("java.lang.Object", info);
        validator.setParameter("java.util.Locale", (Object)Locale.US);
        ValidatorResults results = validator.validate();
        Assertions.assertNotNull((Object)results, (String)"Results are null.");
        ValidatorResult result = results.getValidatorResult("value");
        Assertions.assertNotNull((Object)result, (String)"date value ValidatorResult should not be null.");
        Assertions.assertTrue((boolean)result.containsAction(ACTION), (String)"date value ValidatorResult should contain the 'date' action.");
        Assertions.assertTrue((boolean)(passed ? result.isValid(ACTION) : !result.isValid(ACTION)), (String)("date value ValidatorResult for the 'date' action should have " + (passed ? "passed" : "failed") + "."));
    }
}

