/*
 * Decompiled with CFR 0.152.
 */
package org.apache.woden.xpointer;

import java.util.ArrayList;
import java.util.List;
import org.apache.woden.types.NCName;
import org.apache.woden.xpointer.InvalidXPointerException;
import org.apache.woden.xpointer.PointerPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementPointerPart
implements PointerPart {
    private final NCName ncname;
    private final List<Integer> childSequence;

    public ElementPointerPart(NCName elementID) {
        if (elementID == null) {
            throw new NullPointerException("The elementID argument is null.");
        }
        this.ncname = elementID;
        this.childSequence = null;
    }

    public ElementPointerPart(List<Integer> childSequence) {
        if (childSequence == null) {
            throw new NullPointerException("The childSequence argument is null.");
        }
        if (childSequence.isEmpty()) {
            throw new IllegalArgumentException("The childSequence list is empty.");
        }
        this.ncname = null;
        this.childSequence = childSequence;
    }

    public ElementPointerPart(NCName elementID, List<Integer> childSequence) {
        if (elementID == null) {
            throw new NullPointerException("The elementID argument is null.");
        }
        if (childSequence == null) {
            throw new NullPointerException("The childSequence argument is null.");
        }
        if (childSequence.isEmpty()) {
            throw new IllegalArgumentException("The childSequence list is empty.");
        }
        if (childSequence.contains(0)) {
            throw new IllegalArgumentException("the childSequence list must only contain Integers bigger than 0.");
        }
        this.ncname = elementID;
        this.childSequence = childSequence;
    }

    public NCName getNCName() {
        return this.ncname;
    }

    public Integer[] getChildSequence() {
        int size = this.childSequence.size();
        Integer[] sequence = new Integer[size];
        for (int i = 0; i < size; ++i) {
            sequence[i] = this.childSequence.get(i);
        }
        return sequence;
    }

    public boolean hasNCName() {
        return this.ncname != null;
    }

    public boolean hasChildSequence() {
        return this.childSequence != null;
    }

    @Override
    public String toString() {
        String schemeData = this.childSequence == null ? this.ncname.toString() : (this.ncname == null ? this.serialiseChildSequence() : this.ncname.toString() + this.serialiseChildSequence());
        return "element(" + schemeData + ")";
    }

    private String serialiseChildSequence() {
        StringBuffer buffer = new StringBuffer();
        for (Integer child : this.childSequence) {
            buffer.append("/" + child.toString());
        }
        return buffer.toString();
    }

    public static ElementPointerPart parseFromString(String schemeData) throws InvalidXPointerException {
        ArrayList<Integer> childSequence = null;
        NCName elementID = null;
        int startChar = schemeData.indexOf("/");
        switch (startChar) {
            case -1: {
                try {
                    elementID = new NCName(schemeData);
                }
                catch (IllegalArgumentException e) {
                    throw new InvalidXPointerException("Invalid NCName in the XPointer", schemeData);
                }
                return new ElementPointerPart(elementID);
            }
            case 0: {
                break;
            }
            default: {
                try {
                    elementID = new NCName(schemeData.substring(0, startChar));
                    break;
                }
                catch (IllegalArgumentException e) {
                    throw new InvalidXPointerException("Invalid NCName in the XPointer", schemeData, 0, startChar);
                }
            }
        }
        childSequence = new ArrayList<Integer>();
        int endChar = schemeData.indexOf("/", startChar + 1);
        if (endChar < 0) {
            childSequence.add(ElementPointerPart.parseIntegerFromChildSequence(schemeData, startChar + 1, schemeData.length()));
        } else {
            while (true) {
                if (endChar < 0) {
                    childSequence.add(ElementPointerPart.parseIntegerFromChildSequence(schemeData, startChar + 1, schemeData.length()));
                    break;
                }
                childSequence.add(ElementPointerPart.parseIntegerFromChildSequence(schemeData, startChar + 1, endChar));
                startChar = endChar;
                endChar = schemeData.indexOf("/", startChar + 1);
            }
        }
        if (elementID == null) {
            return new ElementPointerPart(childSequence);
        }
        return new ElementPointerPart(elementID, childSequence);
    }

    private static Integer parseIntegerFromChildSequence(String string, int start, int end) throws InvalidXPointerException {
        if (start < end) {
            try {
                return new Integer(string.substring(start, end));
            }
            catch (NumberFormatException e) {
                throw new InvalidXPointerException("The child sequence part contained a invalid integer.", string, start, end);
            }
        }
        throw new InvalidXPointerException("The child sequence part contained a empty item at " + String.valueOf(start), string, start, end);
    }
}

