/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.cli.kahadb.exporter.artemis;

import java.io.IOException;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.jms.client.ActiveMQDestination;
import org.apache.activemq.artemis.utils.CompositeAddress;
import org.apache.activemq.cli.artemis.schema.ArtemisJournalMarshaller;
import org.apache.activemq.cli.kahadb.exporter.ExportConfiguration;
import org.apache.activemq.cli.kahadb.exporter.MessageStoreMetadataExporter;
import org.apache.activemq.cli.schema.QueueBindingType;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.command.SubscriptionInfo;
import org.apache.activemq.store.kahadb.KahaDBStore;

public class ArtemisXmlMetadataExporter
implements MessageStoreMetadataExporter {
    private final KahaDBStore store;
    private final ArtemisJournalMarshaller xmlMarshaller;
    private final ExportConfiguration config;

    public ArtemisXmlMetadataExporter(KahaDBStore store, ArtemisJournalMarshaller xmlMarshaller, ExportConfiguration config) {
        this.store = store;
        this.xmlMarshaller = xmlMarshaller;
        this.config = config;
    }

    @Override
    public void export() throws IOException {
        this.store.getDestinations().stream().forEach(dest -> {
            try {
                if (dest.isQueue()) {
                    org.apache.activemq.command.ActiveMQDestination mappedToFQQN = this.config.mapToDurableSubFQQN((org.apache.activemq.command.ActiveMQDestination)dest);
                    if (dest != mappedToFQQN) {
                        this.xmlMarshaller.appendBinding(QueueBindingType.builder().withName(CompositeAddress.extractQueueName((String)mappedToFQQN.getPhysicalName())).withRoutingType(RoutingType.MULTICAST.toString()).withAddress(CompositeAddress.extractAddressName((String)mappedToFQQN.getPhysicalName())).build());
                    } else {
                        this.xmlMarshaller.appendBinding(QueueBindingType.builder().withName(dest.getPhysicalName()).withRoutingType(RoutingType.ANYCAST.toString()).withAddress(dest.getPhysicalName()).build());
                    }
                } else if (dest.isTopic()) {
                    for (SubscriptionInfo info : this.store.createTopicMessageStore((ActiveMQTopic)dest).getAllSubscriptions()) {
                        this.xmlMarshaller.appendBinding(QueueBindingType.builder().withName(ActiveMQDestination.createQueueNameForSubscription((boolean)true, (String)info.getClientId(), (String)info.getSubcriptionName()).toString()).withRoutingType(RoutingType.MULTICAST.toString()).withAddress(dest.getPhysicalName()).build());
                    }
                }
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        });
    }
}

