/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.json;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import org.jolokia.json.JSONObject;

public class JSONWriter {
    public static void serialize(Map<String, Object> map, Writer writer) throws IOException {
        writer.write(123);
        int pos = map.size() - 1;
        for (Map.Entry<String, Object> el : map.entrySet()) {
            JSONWriter.escape(writer, el.getKey().toCharArray());
            writer.write(58);
            JSONWriter.serialize(el.getValue(), writer);
            if (pos-- <= 0) continue;
            writer.write(44);
        }
        writer.write(125);
    }

    public static void serializeAnyMap(Map<Object, Object> map, Writer writer) throws IOException {
        writer.write(123);
        int pos = map.size() - 1;
        for (Map.Entry<Object, Object> el : map.entrySet()) {
            JSONWriter.serialize(el.getKey() == null ? "" : el.getKey().toString(), writer);
            writer.write(58);
            JSONWriter.serialize(el.getValue(), writer);
            if (pos-- <= 0) continue;
            writer.write(44);
        }
        writer.write(125);
    }

    public static void serialize(Collection<Object> collection, Writer writer) throws IOException {
        writer.write(91);
        int pos = collection.size() - 1;
        for (Object el : collection) {
            JSONWriter.serialize(el, writer);
            if (pos-- <= 0) continue;
            writer.write(44);
        }
        writer.write(93);
    }

    public static void serialize(Object value, Writer writer) throws IOException {
        if (value == null) {
            writer.write("null");
        } else if (value instanceof Boolean) {
            writer.write((Boolean)value != false ? "true" : "false");
        } else if (value instanceof Float) {
            if (Float.isFinite(((Float)value).floatValue())) {
                writer.write(value.toString());
            } else {
                writer.write("null");
            }
        } else if (value instanceof Double) {
            if (Double.isFinite((Double)value)) {
                writer.write(value.toString());
            } else {
                writer.write("null");
            }
        } else if (value instanceof Number) {
            writer.write(value.toString());
        } else if (value instanceof Character) {
            JSONWriter.escape(writer, new char[]{((Character)value).charValue()});
        } else if (value instanceof String) {
            JSONWriter.escape(writer, ((String)value).toCharArray());
        } else if (value instanceof Collection) {
            JSONWriter.serialize((Collection)value, writer);
        } else if (value instanceof JSONObject) {
            JSONWriter.serialize((JSONObject)value, writer);
        } else if (value instanceof Map) {
            JSONWriter.serializeAnyMap((Map)value, writer);
        } else if (value.getClass().isArray()) {
            int size = Array.getLength(value);
            writer.write(91);
            for (int i = 0; i < size; ++i) {
                JSONWriter.serialize(Array.get(value, i), writer);
                if (i >= size - 1) continue;
                writer.write(44);
            }
            writer.write(93);
        }
    }

    private static void escape(Writer writer, char[] characters) throws IOException {
        StringBuilder buffer = new StringBuilder();
        buffer.append('\"');
        block9: for (char c : characters) {
            switch (c) {
                case '\"': {
                    buffer.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    buffer.append("\\\\");
                    continue block9;
                }
                case '\b': {
                    buffer.append("\\b");
                    continue block9;
                }
                case '\f': {
                    buffer.append("\\f");
                    continue block9;
                }
                case '\n': {
                    buffer.append("\\n");
                    continue block9;
                }
                case '\r': {
                    buffer.append("\\r");
                    continue block9;
                }
                case '\t': {
                    buffer.append("\\t");
                    continue block9;
                }
                default: {
                    if (c <= '\u001f') {
                        buffer.append("\\u00");
                        buffer.append((char)(((c & 0xF0) >> 4) + 48));
                        buffer.append((char)((c & 0xF) + 48));
                        continue block9;
                    }
                    buffer.append(c);
                }
            }
        }
        buffer.append('\"');
        writer.write(buffer.toString());
    }
}

