// THE PURPOSE OF TESTING
// 0. A bug is a coding/design error which prevents the program from functioning as expected.
// 1. Testing is the activity performed with the intent of finding bugs.
// 2. Testing cannot prove the absence of bugs, only their presence.
// 3. Testing is successful only if bugs were found, and useless otherwise.
// 4. Testing is followed by debugging.
// 5. Debugging is the activity performed with the intent of eliminating the bugs.
// 6. Debugging destroys the old program and builds a new one. Which must be tested all over again.
// 7. Testing is never done. Even though the probability of finding bugs decreases, it never reaches 0% ...
// 8. ... at least not for infinite sets of input values. As is usually the case.
// 9. Memorize points 1., 2., and 6. Now get to work!

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include "error.h"

int main(int argc, char **argv)
{
	errno = 3;

	PRINT_ERROR("");
	PRINT_ERROR("01text02text03text04text05text06text07text08text"
		"09text10text11text12text13text14text15text16text"
		"17text18text19text20text21text22text23text24text"
		"25text26text27text28text29text30text31text32text"
		"33text34text35text36text37text38text39text40text"
		"41text42text43text44text45text46text47text48text"
		"49text50text51text52text53text54text55text56text"
		"57text58text59text60text61text62text63text64text");

	PRINT_ERROR_NOERRNO("test no errno");
	print_error(NULL, -52200, -233, NULL, "mary had a little skull");
	print_error('\0', 0, -1, 0);
	print_error("a crazy filename which you won't usually see well at least not in any of my works, hopefully.c",
		__LINE__,
		12,
		"\x23\x32\xA6%s%d THE END");
	PRINT_ERROR_NOERRNO("still going strong\0, didn't crash yet.");

	printf("\n*** THE PROGRAM DID NOT CRASH! ***\n");

	return EXIT_SUCCESS;
}
