import javax.swing.*;

/*
 * TalkEditGUI.java
 *
 * Created on 14. November 2005, 19:11
 */


/**
 *
 *  This class implements the main dialogue where the user can edit
 *  his talks.
 *
 * @author  Olle Nebendahl
 */
public class TalkEditGUI extends JFrame {

    private JFileChooser fc;
    private JButton jButton1;
    private JButton undoButton;
    private JButton saveButton;
    private JButton saveAsNewButton;
    private JButton exportButton;
    
    private JButton jSourceFileButton;
    private JButton jOriginalFileButton;
    private JButton jGoto1StSlideButton;
    
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JTextField jTextField1;
    private JTextField jTextField2;
    private JTextField jTextField3;
    private JTextField jTextField4;
    
    TalkWrapper tw;
    
    SlideRecord firstSlide;
    
    public void setVisible(boolean b)
    {
        if(!b)
        {
            getLocation(Constants.prefTalkEditGUICoordinates);
            Constants.savePreferences();
        }
        else setLocation(Constants.prefTalkEditGUICoordinates);
        super.setVisible(b);
    }
    

    /** Creates new form TalkEditGUI */
    public TalkEditGUI() {
        tw=new TalkWrapper();
        initComponents();
    }
    
    public TalkEditGUI(TalkWrapper wrapper)
    {
        initComponents();
        tw=wrapper;
        load();
    }
    
    private void load()
    {
        jTextField1.setText(tw.getTitle());
        jTextField2.setText(tw.getSubject());
        jTextField3.setText(tw.getSourceFileName());
        jTextField4.setText(tw.getOriginalFileName());
        
        int i = tw.getFirstSlide();
        if(i>0)
        {
            firstSlide=SlideCache.getSlide(i);
            jLabel5.setText(firstSlide.toString());
        }
        
        pack();
    }
    
    private void flush()
    {
        if(null==tw)tw = new TalkWrapper();
        tw.setTitle(jTextField1.getText());
        tw.setSubject(jTextField2.getText());
        tw.setSourceFileName(jTextField3.getText());
        tw.setOriginalFileName(jTextField4.getText());
        
        if(null!=firstSlide)tw.setFirstSlide(firstSlide.getSlideId());
        
        tw.flush();
    }
    
    
    private void initComponents() {
        fc = new JFileChooser();
        jPanel1 = new JPanel();
        jLabel1 = new JLabel();
        jTextField1 = new JTextField();
        jPanel2 = new JPanel();
        jLabel2 = new JLabel();
        jTextField2 = new JTextField();
        jPanel3 = new JPanel();
        jLabel3 = new JLabel();
        jTextField3 = new JTextField();
        jPanel4 = new JPanel();
        jLabel4 = new JLabel();
        jTextField4 = new JTextField();
        jPanel5 = new JPanel();
        jButton1 = new JButton();
        jLabel5 = new JLabel();
        jPanel6 = new JPanel();
        undoButton = new JButton();
        saveButton = new JButton();
        saveAsNewButton = new JButton();
        exportButton = new JButton();

        getContentPane().setLayout(new BoxLayout(getContentPane(), BoxLayout.Y_AXIS));

        jLabel1.setText("talk:");
        jPanel1.add(jLabel1);

        jTextField1.setText("jTextField1");
        jTextField1.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                jTextField1FocusLost(evt);
            }
        });
        jTextField1.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                jTextField1KeyReleased(evt);
            }
        });
        jTextField1.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                jTextField1MouseEntered(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                jTextField1MouseExited(evt);
            }
        });

        jPanel1.add(jTextField1);

        getContentPane().add(jPanel1);

        jLabel2.setText("subject:");
        jPanel2.add(jLabel2);

        jTextField2.setText("jTextField2");
        jTextField2.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                jTextField2FocusLost(evt);
            }
        });

        jPanel2.add(jTextField2);

        getContentPane().add(jPanel2);

        jLabel3.setText("source file:");
        jPanel3.add(jLabel3);

        jTextField3.setText("jTextField3");
        jPanel3.add(jTextField3);
        
        jOriginalFileButton = new JButton();
        jOriginalFileButton.setText("choose...");
        //jPanel3.add(jOriginalFileButton);

        getContentPane().add(jPanel3);

        jLabel4.setText("original source file:");
        jPanel4.add(jLabel4);

        jTextField4.setText("jTextField4");
        jPanel4.add(jTextField4);

        jSourceFileButton = new JButton();
        jSourceFileButton.setText("choose...");
        //jPanel4.add(jSourceFileButton);

        getContentPane().add(jPanel4);

        jButton1.setText("1st slide:");
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });
        jPanel5.add(jButton1);

        jLabel5.setText("hit \"1st slide:\" to assign talk`s first slide");
        jPanel5.add(jLabel5);
        
        jGoto1StSlideButton = new JButton();
        jGoto1StSlideButton.setText("go");
        jGoto1StSlideButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jGoto1StSlideButtonActionPerformed(evt);
            }
        });
        jPanel5.add(jGoto1StSlideButton);

        getContentPane().add(jPanel5);

        undoButton.setText("undo all changes");
        undoButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                undoButtonActionPerformed(evt);
            }
        });

        jPanel6.add(undoButton);

        saveButton.setText("save changes");
        saveButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                saveButtonActionPerformed(evt);
            }
        });

        jPanel6.add(saveButton);

        saveAsNewButton.setText("save as new");
        saveAsNewButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                saveAsNewButtonActionPerformed(evt);
            }
        });

        jPanel6.add(saveAsNewButton);

        exportButton.setText("export");
        exportButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                exportButtonActionPerformed(evt);
            }
        });

        jPanel6.add(exportButton);

        getContentPane().add(jPanel6);

        pack();
    }


    private void jGoto1StSlideButtonActionPerformed(java.awt.event.ActionEvent evt) 
    {
        if(firstSlide!=null)
        {
            final SlideEditGUI seg = new SlideEditGUI(new SlideWrapper(firstSlide.getSlideId()));
            java.awt.EventQueue.invokeLater(new Runnable() {
                public void run() {
                    seg.setVisible(true);
                }
            });
        }
    }

    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) 
    {
        firstSlide = WorkingPool.getSelected();
        if(null==firstSlide)
        {
            jLabel5.setText("hit \"1st slide:\" to assign talk`s first slide");
            return;
        }
        jLabel5.setText(firstSlide.toString());
        pack();
    }

    private void exportButtonActionPerformed(java.awt.event.ActionEvent evt) 
    {
        int sorLength;
        
        int fcret = fc.showSaveDialog(this);
        if(fcret==fc.APPROVE_OPTION)
        {
            StringBuffer sb = new StringBuffer();
            CommandRepresentation cr = PrefSlideCommands.getFirst();
            System.out.println(cr.i);
            int i;
            SlideOrderRecord sor;
            SlideRecord sr = firstSlide;
            java.util.TreeMap cache=new java.util.TreeMap();
            while(sr!=null)
            {
                cache.put(new Integer(sr.getSlideId()),null);
                sb.append("\n");
                sb.append("\n");
                sb.append("\n");
                sb.append(cr.s);
                i=0;
                while(i<cr.i)
                {
                    if(i+1==cr.bodyTarget)
                    {
                        sb.append("{");
                        sb.append(SlideConnection.getSlideSourceByIdSt(sr.getSlideId()));
                        sb.append("}");                    
                    }
                    if(i+1==cr.titleTarget)
                    {
                        sb.append("{");
                        sb.append(sr.getTitle());
                        sb.append("}");                    
                    }
                    i++;
                }
                sor=SlideOrderCache.getSlideOrder(sr.getSlideId());
                sorLength=sor.succ.length;
                if(sorLength>0)
                {
                    int j = 0;
                    sr=null;
                    
                    // In this while-loop all succeeding slides that are 
                    // attached to this talk are checked if they are already
                    // exported. sr non-null means that an unexportes slide
                    // is found.
                    while((sr==null)&&(j<sorLength))
                    {
                        sr=SlideCache.getSlide(sor.succ[j]);
                        if(SlideBelongsToTalkCache.get(sr.getSlideId())!=tw.getTalkId())sr=null;
                        if(sr!=null)if(cache.containsKey(new Integer(sr.getSlideId())))sr=null;
                        j++;
                    }
                    j=0;
                    
                    // In this while-loop, all succeeding slides are checked.
                    // chosen if unexported
                    while((sr==null)&&(j<sorLength))
                    {
                        sr=SlideCache.getSlide(sor.succ[j]);
                        if(sr!=null)if(cache.containsKey(new Integer(sr.getSlideId())))sr=null;
                        j++;
                    }
                }
                else sr=null;
            }
            FOS.writeToFile(fc.getSelectedFile().getAbsolutePath(),sb.toString());
            jTextField3.setText(fc.getSelectedFile().getName());
        }
    }

    private void jTextField2FocusLost(java.awt.event.FocusEvent evt) 
    {
        //System.out.println("2lost");
    }


    private void jTextField1FocusLost(java.awt.event.FocusEvent evt) 
    {
        //System.out.println("1lost");
    }

    private void jTextField1MouseExited(java.awt.event.MouseEvent evt) 
    {
        //System.out.println("maus ex");
    }

    private void jTextField1MouseEntered(java.awt.event.MouseEvent evt) 
    {
        //System.out.println("ME");
    }

    private void saveAsNewButtonActionPerformed(java.awt.event.ActionEvent evt) 
    {
        Logger.log("save talk as new");
        tw.exists=false;
        flush();
    }

    private void saveButtonActionPerformed(java.awt.event.ActionEvent evt) 
    {
        flush();
        System.out.println(tw);
    }

    private void jTextField1KeyReleased(java.awt.event.KeyEvent evt) 
    {
        //System.out.println("field1.keyreleased: "+evt.getKeyCode());
    }

    private void undoButtonActionPerformed(java.awt.event.ActionEvent evt) 
    {
        load();
    }
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) 
    {
        final TalkEditGUI tag = new TalkEditGUI(new TalkWrapper(Integer.decode(args[0]).intValue()));
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                tag.setVisible(true);
            }
        });
    }
}
