% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wiki_utils.R
\name{reqMediaWiki}
\alias{reqMediaWiki}
\title{Uses httr package to retrieve responses using the MediaWiki API.}
\usage{
reqMediaWiki(
  query,
  project = "en.wikipedia.org",
  method = "GET",
  attempts = 2,
  debug = FALSE
)
}
\arguments{
\item{query}{A list with de (key, values) pairs with the search.
Note that if titles are included in the query, the MediaWiki API has a
limit of 50 titles in each query. If number of titles is greater than this
limit a error is raised.}

\item{project}{The Wikimedia project to search. Default en.wikipedia.org.}

\item{method}{The method used in the httr request. Default 'GET'.
Note in "https://www.mediawiki.org/wiki/API:Etiquette#Request_limit":
"Whenever you're reading data from the web service API, you should try to use
GET requests if possible, not POST, as the latter are not cacheable."}

\item{attempts}{On ratelimit errors, the number of times the request is
retried using a 60 seconds interval between retries. Default 2. If 0 no
retries are done.}

\item{debug}{For debugging purposes (default FALSE). If debug='info'
information about chunked queries is shown. If debug='query' also the query
launched is shown.}
}
\value{
The response in JSON format, raise exception on errors.
}
\description{
For MediaWiki requests only user_agent is necessary in the request headers.
See https://www.mediawiki.org/wiki/API:Etiquette. The standard and default
output format in MediaWiki is JSON. All other formats are discouraged. The
output format should always be specified using the request param "format"
in the "query" request.
See https://www.mediawiki.org/wiki/API:Data_formats#Output.
}
\author{
Angel Zazo, Department of Computer Science and Automatics, University of Salamanca
}
