% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trace.R
\name{jit_save_for_mobile}
\alias{jit_save_for_mobile}
\title{Saves a \code{script_function} or \code{script_module} in bytecode form,
to be loaded on a mobile device}
\usage{
jit_save_for_mobile(obj, path, ...)
}
\arguments{
\item{obj}{An \code{script_function} or \code{script_module} to save}

\item{path}{The path to save the serialized function.}

\item{...}{currently unused}
}
\description{
Saves a \code{script_function} or \code{script_module} in bytecode form,
to be loaded on a mobile device
}
\examples{
if (torch_is_installed()) {
fn <- function(x) {
  torch_relu(x)
}

input <- torch_tensor(c(-1, 0, 1))
tr_fn <- jit_trace(fn, input)

tmp <- tempfile("tst", fileext = "pt")
jit_save_for_mobile(tr_fn, tmp)
}
}
