% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-tidycpt.R
\name{tidycpt-class}
\alias{tidycpt-class}
\title{Container class for \code{tidycpt} objects}
\value{
A \linkS4class{tidycpt} object.
}
\description{
Container class for \code{tidycpt} objects
}
\details{
Every \code{tidycpt} object contains:
\itemize{
\item \code{segmenter}: The object returned by the underlying changepoint
detection algorithm. These can be of arbitrary class. Use \code{\link[=as.segmenter]{as.segmenter()}}
to retrieve them.
\item \code{model}: A model object inheriting from \link{mod_cpt}, as created by
\code{\link[=as.model]{as.model()}} when called on the \code{segmenter}.
\item \code{elapsed_time}: The clock time that passed while the algorithm was running.
\item \code{time_index}: If available, the labels for the time indices of the time series.
}
}
\examples{
# Segment a time series using PELT
x <- segment(CET, method = "pelt")
class(x)
str(x)

}
