% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CDORemapper.R
\name{CDORemapper}
\alias{CDORemapper}
\title{CDO Remap Data Transformation for 'startR'}
\usage{
CDORemapper(
  data_array,
  variables,
  file_selectors = NULL,
  crop_domain = NULL,
  ...
)
}
\arguments{
\item{data_array}{A data array to be transformed. See details in the 
documentation of the parameter 'transform' of the function Start().}

\item{variables}{A list of auxiliary variables required for the transformation, 
automatically provided by Start(). See details in the documentation of the 
parameter 'transform' of the function Start().}

\item{file_selectors}{A charcter vector indicating the information of the path of
the file parameter 'data_array' comes from. See details in the documentation of
the parameter 'transform' of the function Start(). The default value is NULL.}

\item{crop_domain}{A list of the transformed domain of each transform 
variable, automatically provided by Start().}

\item{\dots}{A list of additional parameters to adjust the transform process, 
as provided in the parameter 'transform_params' in a Start() call. See details
in the documentation of the parameter 'transform' of the function Start().}
}
\value{
An array with the same amount of dimensions as the input data array, 
 potentially with different sizes, and potentially with the attribute 
 'variables' with additional auxiliary data. See details in the documentation 
 of the parameter 'transform' of the function Start().
}
\description{
This is a transform function that uses CDO software to remap longitude-latitude 
data subsets onto a specified target grid, intended for use as parameter 
'transform' in a Start() call. This function complies with the input/output 
interface required by Start() defined in the documentation for the parameter 
'transform' of function Start().\cr\cr
This function uses the function CDORemap() in the package 's2dv' to 
perform the interpolation, hence CDO is required to be installed.
}
\examples{
# Used in Start():
 data_path <- system.file('extdata', package = 'startR')
 path_obs <- file.path(data_path, 'obs/monthly_mean/$var$/$var$_$sdate$.nc')
 sdates <- c('200011')
 \dontrun{
 data <- Start(dat = list(list(path = path_obs)),
               var = 'tos',
               sdate = sdates,
               time = 'all',
               latitude = values(list(-60, 60)),
               latitude_reorder = Sort(decreasing = TRUE),
               longitude = values(list(-120, 120)),
               longitude_reorder = CircularSort(-180, 180),
               transform = CDORemapper,
               transform_params = list(grid = 'r360x181',
                                       method = 'conservative'),
               transform_vars = c('latitude', 'longitude'),
               return_vars = list(latitude = 'dat',
                                  longitude = 'dat',
                                  time = 'sdate'),
               retrieve = FALSE)
}
}
\seealso{
\code{\link[s2dv]{CDORemap}}
}
