% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NEW_k_functions_nettime_sf.R
\name{k_nt_functions.mc}
\alias{k_nt_functions.mc}
\title{Network k and g functions for spatio-temporal data (multicore, experimental, NOT READY FOR USE)}
\usage{
k_nt_functions.mc(
  lines,
  points,
  points_time,
  start_net,
  end_net,
  step_net,
  width_net,
  start_time,
  end_time,
  step_time,
  width_time,
  nsim,
  conf_int = 0.05,
  digits = 2,
  tol = 0.1,
  resolution = NULL,
  agg = NULL,
  verbose = TRUE,
  calc_g_func = TRUE,
  grid_shape = c(1, 1)
)
}
\arguments{
\item{lines}{A feature collection of linestrings representing the underlying network. The
geometries must be simple Linestrings (may crash if some geometries
are invalid) without MultiLineSring}

\item{points}{A feature collection of points representing the points on the
network. These points will be snapped on their nearest line}

\item{points_time}{A numeric vector indicating when the point occured}

\item{start_net}{A double, the lowest network distance used to evaluate the k and g functions}

\item{end_net}{A double, the highest network distance used to evaluate  the k and g functions}

\item{step_net}{A double, the step between two evaluations of the k and g for the network distance
function. start_net, end_net and step_net are used to create a vector of distances with the function seq}

\item{width_net}{The width (network distance) of each donut for the g-function. Half of the width is applied on
both sides of the considered distance}

\item{start_time}{A double, the lowest time distance used to evaluate the k and g functions}

\item{end_time}{A double, the highest time distance used to evaluate  the k and g functions}

\item{step_time}{A double, the step between two evaluations of the k and g for the time distance
function. start_time, end_time and step_time are used to create a vector of distances with the function seq}

\item{width_time}{The width (time distance) of each donut for the g-function. Half of the width is applied on
both sides of the considered distance}

\item{nsim}{An integer indicating the number of Monte Carlo simulations
to perform for inference}

\item{conf_int}{A double indicating the width confidence interval (default =
0.05) calculated on the Monte Carlo simulations}

\item{digits}{An integer indicating the number of digits to retain from the
spatial coordinates}

\item{tol}{When adding the points to the network, specify the minimum
distance between these points and the lines' extremities. When points are
closer, they are added at the extremity of the lines}

\item{resolution}{When simulating random points on the network, selecting a
resolution will reduce greatly the calculation time. When resolution is null
the random points can occur everywhere on the graph. If a value is specified,
the edges are split according to this value and the random points can only be
vertices on the new network}

\item{agg}{A double indicating if the events must be aggregated within a distance.
If NULL, the events are aggregated only by rounding the coordinates}

\item{verbose}{A Boolean indicating if progress messages should be displayed}

\item{calc_g_func}{A boolean indicating if the G function must also be calculated}

\item{grid_shape}{A vector of two values indicating how the study area
must be split when performing the calculus. Default is c(1,1) (no split). A finer grid could
reduce memory usage and increase speed when a large dataset is used. When using
multiprocessing, the work in each grid is dispatched between the workers.}
}
\value{
A list with the following values :
\itemize{
\item obs_k: A matrix with the observed k-values
\item lower_k: A matrix with the lower bounds of the simulated k-values
\item upper_k: A matrix with the upper bounds of the simulated k-values
\item obs_g: A matrix with the observed g-values
\item lower_g: A matrix with the lower bounds of the simulated g-values
\item upper_g: A matrix with the upper bounds of the simulated g-values
\item distances_net: A vector with the used network distances
\item distances_time: A vector with the used time distances
}
}
\description{
Calculate the k and g functions for a set of points on a
network and in time (multicore, experimental, NOT READY FOR USE).
}
\details{
The k-function is a method to characterize the dispersion of a set
of points. For each point, the numbers of other points in subsequent radii
are calculated. This empirical k-function can be more or less clustered
than a k-function obtained if the points were randomly located in space. In
a network, the network distance is used instead of the Euclidean distance.
This function uses Monte Carlo simulations to assess if the points are
clustered or dispersed, and gives the results as a line plot. If the line
of the observed k-function is higher than the shaded area representing the
values of the simulations, then the points are more clustered than what we
can expect from randomness and vice-versa. The function also calculates the
g-function, a modified version of the k-function using rings instead of
disks. The width of the ring must be chosen. The main interest is to avoid
the cumulative effect of the classical k-function. This function is maturing,
it works as expected (unit tests) but will probably be modified in the
future releases (gain speed, advanced features, etc.).
}
