% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalizationFunction.R
\name{unnormalizeData}
\alias{unnormalizeData}
\title{Unnormalization of given data}
\usage{
unnormalizeData(dataInput)
}
\arguments{
\item{dataInput}{a list file composed of two parts
First part is the data that will be unnormalized, which is a dataframe composed of two columns. One is for time and the other is for intensity
Second part is the scaling parameters of the data which is a vector that has three components. The first is related with time and second two are related with intensity. The second value represents the min value of the intensity set. First and third values represent the difference between max and min value in the relevant column.}
}
\value{
Returns a dataframe, scaling factors, and scaling constants for time and intensity. The other data frame includes 2 columns: normalized time and normalized intensity. The time and intensity constants and scaling factors are the parameters to transform data from given set to scaled set.
}
\description{
Maps the given time-intensity data into a rescaled frame where time is between zero and one intensity is also between zero and one.
}
\examples{
# runif() is used here for consistency with previous versions of the sicegar package. However,
# rnorm() will generate symmetric errors, producing less biased numerical parameter estimates.
# We recommend errors generated with rnorm() for any simulation studies on sicegar.
# generateRandomData
time <- seq(3, 48, 0.5)
intensity <- runif(length(time), 3.0, 7.5)
dataInput <- data.frame(time, intensity)
# Normalize Data
dataOutput <- normalizeData(dataInput)
dataInput2 <- dataOutput
# Un Normalize it
dataOutput2 <- unnormalizeData(dataInput2)

}
