% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssimLibrary.R
\name{ssimLibrary}
\alias{ssimLibrary}
\alias{ssimLibrary,SsimObject-method}
\alias{ssimLibrary,missingOrNULLOrChar-method}
\title{Create or open a SsimLibrary}
\usage{
ssimLibrary(
  name = NULL,
  summary = NULL,
  packages = NULL,
  session = NULL,
  forceUpdate = FALSE,
  overwrite = FALSE,
  useConda = NULL
)

\S4method{ssimLibrary}{SsimObject}(
  name = NULL,
  summary = NULL,
  packages = NULL,
  session = NULL,
  forceUpdate = FALSE,
  overwrite = FALSE,
  useConda = NULL
)

\S4method{ssimLibrary}{missingOrNULLOrChar}(
  name = NULL,
  summary = NULL,
  packages = NULL,
  session = NULL,
  forceUpdate = FALSE,
  overwrite = FALSE,
  useConda = NULL
)
}
\arguments{
\item{name}{\code{\link{SsimLibrary-class}}, \code{\link{Project-class}} or
\code{\link{Scenario-class}} object, or character string (i.e. path to a SsimLibrary
or SsimObject)}

\item{summary}{logical. Default is \code{TRUE}}

\item{packages}{character or character vector. The SyncroSim Package(s) to
add to the Library if creating a new Library (optional)}

\item{session}{\code{\link{Session-class}} object. If \code{NULL} (default), session()
will be used}

\item{forceUpdate}{logical. If \code{FALSE} (default) user will be prompted to approve
any required updates. If \code{TRUE}, required updates will be applied silently.}

\item{overwrite}{logical. If \code{TRUE} an existing SsimLibrary will be overwritten}

\item{useConda}{logical. If set to TRUE, then all packages associated with the
Library will have their Conda environments created and Conda environments will
be used during runtime.If set to FALSE, then no packages will have their
Conda environments created and Conda environments will not be used during runtime.
Default is NULL}
}
\value{
Returns a \code{\link{SsimLibrary-class}} object.
}
\description{
Creates or opens a \code{\link{SsimLibrary-class}} object.
If \code{summary = TRUE}, returns SsimLibrary summary info.
If \code{summary = NULL}, returns SsimLibrary summary info if ssimObject is a SsimLibrary,
SsimLibrary object otherwise.
}
\details{
Example arguments:
\itemize{
\item If name is SyncroSim Project or Scenario: Returns the
\code{\link{SsimLibrary-class}} associated with the Project or Scenario.
\item If name is \code{NULL}: Create/open a SsimLibrary in the current working
directory with the filename SsimLibrary.ssim.
\item If name is a string: If string is not a valid path treat as filename
in working directory. If no file suffix provided in string then add
.ssim. Attempts to open a SsimLibrary of that name. If SsimLibrary does not
exist creates a SsimLibrary of type package in the current working directory.
\item If given a name and a package: Create/open a SsimLibrary called \link{name}.ssim.
Returns an error if the SsimLibrary already exists but is a different type
of package.
}
}
\examples{
\dontrun{
# Make sure packages are installed
installPackage("stsim")

# Create or open a SsimLibrary using the default Session
myLibrary <- ssimLibrary(name = file.path(tempdir(), "mylib"))

# Create SsimLibrary using a specific Session
mySession <- session()

myLibrary <- ssimLibrary(name = file.path(tempdir(), "mylib"),
                         session = mySession)

# Retrieve SsimLibrary properties
session(myLibrary)

# Create SsimLibrary from template
installPackage("helloworldSpatial")
mySession <- session()
myLibrary <- ssimLibrary(name = file.path(tempdir(), "mylib"), 
                         session = mySession,
                         forceUpdate = TRUE,
                         packages = "helloworldSpatial",
                         overwrite = TRUE)
                         
}

}
