% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/listing_export.R
\docType{import}
\name{reexports}
\alias{reexports}
\alias{export_as_txt}
\title{Objects exported from other packages}
\examples{
dat <- ex_adae

lsting <- as_listing(dat[1:25, ], key_cols = c("USUBJID", "AESOC")) \%>\%
  add_listing_col("AETOXGR") \%>\%
  add_listing_col("BMRKR1", format = "xx.x") \%>\%
  add_listing_col("AESER / AREL", fun = function(df) paste(df$AESER, df$AREL, sep = " / "))
main_title(lsting) <- "this is some title"
main_footer(lsting) <- "this is some footer"

cat(export_as_txt(lsting, file = NULL, paginate = TRUE))

}
\keyword{internal}
\description{
These objects are imported from other packages. Follow the links
below to see their documentation.

\describe{
  \item{formatters}{\code{\link[formatters]{export_as_txt}}}
}}

