% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rlistings_methods.R
\name{make_row_df,listing_df-method}
\alias{make_row_df,listing_df-method}
\title{Make pagination data frame for a listing}
\usage{
\S4method{make_row_df}{listing_df}(
  tt,
  colwidths = NULL,
  visible_only = TRUE,
  rownum = 0,
  indent = 0L,
  path = character(),
  incontent = FALSE,
  repr_ext = 0L,
  repr_inds = integer(),
  sibpos = NA_integer_,
  nsibs = NA_integer_,
  fontspec = dflt_courier,
  round_type = obj_round_type(tt)
)
}
\arguments{
\item{tt}{(\code{listing_df})\cr the listing to be rendered.}

\item{colwidths}{(\code{numeric})\cr internal detail, do not set manually.}

\item{visible_only}{(\code{flag})\cr ignored, as listings do not have
non-visible structural elements.}

\item{rownum}{(\code{numeric(1)})\cr internal detail, do not set manually.}

\item{indent}{(\code{integer(1)})\cr internal detail, do not set manually.}

\item{path}{(\code{character})\cr path to the (sub)table represented by \code{tt}. Defaults to \code{character()}.}

\item{incontent}{(\code{flag})\cr internal detail, do not set manually.}

\item{repr_ext}{(\code{integer(1)})\cr internal detail, do not set manually.}

\item{repr_inds}{(\code{integer})\cr internal detail, do not set manually.}

\item{sibpos}{(\code{integer(1)})\cr internal detail, do not set manually.}

\item{nsibs}{(\code{integer(1)})\cr internal detail, do not set manually.}

\item{fontspec}{(\code{font_spec})\cr a font_spec object specifying the font information to use for
calculating string widths and heights, as returned by \code{\link[formatters:font_spec]{font_spec()}}.}

\item{round_type}{(\code{string})\cr .
\cr The type of rounding to perform. Allowed values: (\code{"iec"}, \code{"iec_mod"} or \code{"sas"})
\cr iec, the default, and iec_mod performs rounding compliant with IEC 60559
(see notes in \code{\link[formatters:round_fmt]{round_fmt()}}), while
sas performs nearest-value rounding consistent with rounding within SAS.\cr
In addition, the rounding of a negative number that rounds to zero will be presented as 0
(with the appropriate number of trailing zeros) for both \code{sas} and \code{iec_mod},
while for \code{iec}, it will be presented as -0 (with the appropriate number of trailing zeros).}
}
\value{
a \code{data.frame} with pagination information.
}
\description{
Make pagination data frame for a listing
}
\examples{
lsting <- as_listing(mtcars)
mf <- matrix_form(lsting)

}
\seealso{
\code{\link[formatters:make_row_df]{formatters::make_row_df()}}
}
