% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class112-recording_blocks_voltage.R
\name{RAVESubjectRecordingBlockVoltageRepository}
\alias{RAVESubjectRecordingBlockVoltageRepository}
\title{'RAVE' class for blocks of voltage repository}
\description{
Compared to \code{\link{RAVESubjectBaseRepository}}, this repository
loads the entire voltage traces for selected blocks; use
\code{\link{prepare_subject_voltage_with_blocks}} to instantiate this
repository.
}
\seealso{
\code{\link{prepare_subject_voltage_with_blocks}}
}
\section{Super classes}{
\code{\link[ravepipeline:RAVESerializable]{ravepipeline::RAVESerializable}} -> \code{ravecore::RAVESubjectRepository} -> \code{\link[ravecore:RAVESubjectRecordingBlockRepository]{ravecore::RAVESubjectRecordingBlockRepository}} -> \code{RAVESubjectRecordingBlockVoltageRepository}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{sample_rates}}{a named list of sampling frequencies; the names
are signal types (\code{'LFP'}, \code{'Auxiliary'}, or \code{'Spike'})
and the values are the sampling frequencies}

\item{\code{voltage}}{data container, alias of \code{get_container}}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-RAVESubjectRecordingBlockVoltageRepository-@marshal}{\code{RAVESubjectRecordingBlockVoltageRepository$@marshal()}}
\item \href{#method-RAVESubjectRecordingBlockVoltageRepository-@unmarshal}{\code{RAVESubjectRecordingBlockVoltageRepository$@unmarshal()}}
\item \href{#method-RAVESubjectRecordingBlockVoltageRepository-new}{\code{RAVESubjectRecordingBlockVoltageRepository$new()}}
\item \href{#method-RAVESubjectRecordingBlockVoltageRepository-mount_data}{\code{RAVESubjectRecordingBlockVoltageRepository$mount_data()}}
\item \href{#method-RAVESubjectRecordingBlockVoltageRepository-clone}{\code{RAVESubjectRecordingBlockVoltageRepository$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="ravepipeline" data-topic="RAVESerializable" data-id="@compare"><a href='../../ravepipeline/html/RAVESerializable.html#method-RAVESerializable-@compare'><code>ravepipeline::RAVESerializable$@compare()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ravecore" data-topic="RAVESubjectRepository" data-id="@get_container"><a href='../../ravecore/html/RAVESubjectRepository.html#method-RAVESubjectRepository-@get_container'><code>ravecore::RAVESubjectRepository$@get_container()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ravecore" data-topic="RAVESubjectRecordingBlockRepository" data-id="export_matlab"><a href='../../ravecore/html/RAVESubjectRecordingBlockRepository.html#method-RAVESubjectRecordingBlockRepository-export_matlab'><code>ravecore::RAVESubjectRecordingBlockRepository$export_matlab()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ravecore" data-topic="RAVESubjectRecordingBlockRepository" data-id="get_container"><a href='../../ravecore/html/RAVESubjectRecordingBlockRepository.html#method-RAVESubjectRecordingBlockRepository-get_container'><code>ravecore::RAVESubjectRecordingBlockRepository$get_container()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RAVESubjectRecordingBlockVoltageRepository-@marshal"></a>}}
\if{latex}{\out{\hypertarget{method-RAVESubjectRecordingBlockVoltageRepository-@marshal}{}}}
\subsection{Method \code{@marshal()}}{
Internal method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RAVESubjectRecordingBlockVoltageRepository$@marshal(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{internal arguments}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RAVESubjectRecordingBlockVoltageRepository-@unmarshal"></a>}}
\if{latex}{\out{\hypertarget{method-RAVESubjectRecordingBlockVoltageRepository-@unmarshal}{}}}
\subsection{Method \code{@unmarshal()}}{
Internal method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RAVESubjectRecordingBlockVoltageRepository$@unmarshal(object, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{object, ...}}{internal arguments}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RAVESubjectRecordingBlockVoltageRepository-new"></a>}}
\if{latex}{\out{\hypertarget{method-RAVESubjectRecordingBlockVoltageRepository-new}{}}}
\subsection{Method \code{new()}}{
constructor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RAVESubjectRecordingBlockVoltageRepository$new(
  subject,
  electrodes = NULL,
  reference_name = NULL,
  blocks = NULL,
  downsample = NA,
  ...,
  quiet = FALSE,
  repository_id = NULL,
  strict = TRUE,
  lazy_load = FALSE,
  .class = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{subject}}{'RAVE' subject}

\item{\code{electrodes}}{string or integers indicating electrodes to load}

\item{\code{reference_name}}{name of the reference table}

\item{\code{blocks}}{name of the recording blocks to load}

\item{\code{downsample}}{down-sample rate by this integer number to save space
and speed up computation; typically 'ERP' signals do not need super
high sampling frequencies to load; default is \code{NA} and no
down-sample is performed.}

\item{\code{...}}{passed to \code{\link{RAVESubjectBaseRepository}} constructor}

\item{\code{quiet}}{see field \code{quiet}}

\item{\code{repository_id}}{see field \code{repository_id}}

\item{\code{strict}}{whether the mode should be strict; default is true and
errors out when subject is missing}

\item{\code{lazy_load}}{whether to delay (lazy) the evaluation \code{mount_data}}

\item{\code{.class}}{internally used, do not set, even if you know what this is}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RAVESubjectRecordingBlockVoltageRepository-mount_data"></a>}}
\if{latex}{\out{\hypertarget{method-RAVESubjectRecordingBlockVoltageRepository-mount_data}{}}}
\subsection{Method \code{mount_data()}}{
function to mount data
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RAVESubjectRecordingBlockVoltageRepository$mount_data(
  ...,
  force = TRUE,
  electrodes = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{reserved}

\item{\code{force}}{force update data; default is true; set to false
to use cache}

\item{\code{electrodes}}{electrodes to update; default is \code{NULL} (all
electrode channels)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RAVESubjectRecordingBlockVoltageRepository-clone"></a>}}
\if{latex}{\out{\hypertarget{method-RAVESubjectRecordingBlockVoltageRepository-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RAVESubjectRecordingBlockVoltageRepository$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
