% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rSDR.R
\name{rSDR}
\alias{rSDR}
\title{Robust Sufficient Dimension Reduction}
\usage{
rSDR(X, Y, d, alpha=0.5,maxiter=1000,tol=1e-7)
}
\arguments{
\item{X}{an \eqn{n \times p} numeric matrix, where \eqn{n} is the number of observations and \eqn{p} is the number of variable.}

\item{Y}{an \eqn{n \times k} numeric response matrix, where \eqn{k (\geq 1)} is the number of response variables.}

\item{d}{the number of reduced dimension.}

\item{alpha}{this parameter represents the exponent applied to the Euclidean distance in the computation of distance covariance. When alpha=1, it corresponds to the classical distance covariance. When 0 < alpha < 1, it is a more robust version by reducing the influence of large values in the distance matrices.}

\item{maxiter}{maxiter is the maximum number of iterations allowed for the solver (a non-negative integer). See the Max_Iteration parameter in \code{\link[ManifoldOptim]{get.solver.params}} for details.}

\item{tol}{tol is used to assess convergence, see the Tolerance parameter in \code{\link[ManifoldOptim]{get.solver.params}} for details.}
}
\value{
The returned value is an object of class "rSDR", containing the following components:
\describe{
\item{projected_data}{an \eqn{n \times d} matrix representing the projected data using the rSDR method.}
\item{beta}{a \eqn{p \times d} matrix.Solve \eqn{\boldsymbol{\beta}} by \eqn{\textbf{C}=\Sigma_x^{1/2} \boldsymbol{\beta}}}
\item{C_value}{an optimal of C is obtained by maximizing the target function using ManifoldOptim method.}
\item{f_value}{The value of cost function f is defined as the negative of the target function.}
}
}
\description{
Robust Sufficient Dimension Reduction with alpha-Distance Covariance and Stiefel Manifold Learning for supervised dimension reduction.
}
\examples{

library(ManifoldOptim)
library(rSDR)
utils::data("ionosphere", package = "fdm2id")
X<-as.matrix(ionosphere[,c(1:33)])
Y<-ifelse(ionosphere[,34]=='b',0,1)
Y<-matrix(Y,length(Y),1)
set.seed(2435)
\donttest{
sdr_result<-rSDR(X=X, Y=Y, d=3, alpha=0.3,maxiter=1000,tol=1e-7)
}
}
\references{
Hsin-Hsiung Huang, Feng Yu & Teng Zhang (19 Feb 2024): Robust sufficient dimension reduction via alpha-distance covariance, Journal of Nonparametric Statistics, DOI:10.1080/10485252.2024.2313137
}
