% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmr.R
\name{compute_SB}
\alias{compute_SB}
\title{Compute Between-Group Scatter Matrix}
\usage{
compute_SB(A, g)
}
\arguments{
\item{A}{A numeric matrix of dimensions \code{m x n}, where rows represent observations and columns represent features.}

\item{g}{A grouping variable of length \code{m}, either a factor or a character vector, indicating group membership for each observation.}
}
\value{
A numeric matrix representing the between-group scatter matrix (\code{SB}).
}
\description{
This function calculates the between-group scatter matrix (\code{SB}) for a given numeric matrix and grouping variable.
}
\details{
The function computes the total mean of the matrix \code{A} and the mean for each group defined by \code{g}.
It then calculates the between-group scatter matrix by summing the outer product of the mean differences, weighted by the group sizes.
}
\examples{
# Example usage:
A <- matrix(rnorm(20), nrow = 5, ncol = 4)
g <- factor(c("A", "B", "A", "B", "A"))
SB <- rENA:::compute_SB(A, g)
}
