% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exported_functions.R
\name{check_map}
\alias{check_map}
\title{Check the quality of a linkage map}
\usage{
check_map(
  linkage_list,
  maplist,
  mapfn = "haldane",
  lod.thresh = 5,
  detail = 1,
  plottype = c("", "pdf", "png")[1],
  prefix = ""
)
}
\arguments{
\item{linkage_list}{A named \code{list} with r and LOD of markers within linkage groups.}

\item{maplist}{A list of maps. In the first column marker names and in the second their position.}

\item{mapfn}{The map function used in generating the maps, either one of "haldane" or "kosambi". By default "haldane" is assumed.}

\item{lod.thresh}{Numeric. Threshold for the LOD values to be displayed in heatmap, by default 5 (set at 0 to display all values)}

\item{detail}{Level of detail for heatmaps, by default 1 cM. Values less than 0.5 cM can have serious performance implications.}

\item{plottype}{Option to specify graphical device for plotting, (either png or pdf), or by default "", in which case plots are directly plotted within R}

\item{prefix}{Optional prefix appended to plot names if outputting plots.}
}
\description{
Perform a series of checks on a linkage map and visualise the results using heatplots. The difference between
the pairwise and multi-point r estimates are also plotted against the LOD of the pairwise estimate. The weighted root mean square error 
of these differences (weighted by the LOD scores) is printed on the console.
}
\examples{
\dontrun{
data("maplist_P1","all_linkages_list_P1")
check_map(linkage_list = all_linkages_list_P1, maplist = maplist_P1)
}
}
