% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.metadata.r
\name{getWhenMeasured}
\alias{getWhenMeasured}
\alias{when_measured}
\alias{getWhenMeasured.default}
\alias{getWhenMeasured.generic_spct}
\alias{getWhenMeasured.summary_generic_spct}
\alias{getWhenMeasured.data.frame}
\alias{getWhenMeasured.generic_mspct}
\title{Get the "when.measured" attribute}
\usage{
getWhenMeasured(x, ...)

when_measured(x, ...)

\method{getWhenMeasured}{default}(x, ...)

\method{getWhenMeasured}{generic_spct}(x, as.df = FALSE, ..., simplify = FALSE)

\method{getWhenMeasured}{summary_generic_spct}(x, as.df = FALSE, ..., simplify = FALSE)

\method{getWhenMeasured}{data.frame}(x, as.df = FALSE, ..., simplify = FALSE)

\method{getWhenMeasured}{generic_mspct}(x, ..., idx = "spct.idx", simplify = FALSE)
}
\arguments{
\item{x}{an R object}

\item{...}{Allows use of additional arguments in methods for other classes.}

\item{as.df}{logical If \code{TRUE} return a data frame instead of a list,
when the value stored in the attribute is a list.}

\item{simplify}{logical If all members share the same attribute value return
one copy instead of a data.frame.}

\item{idx}{character Name of the column with the names of the members of the
collection of spectra.}
}
\value{
a \code{POSIXct} object with date and time, or named list of such
  objects, or, on user request, a data frame.
}
\description{
Method to read the \code{"when.measured"} attribute of an R object.
}
\section{Methods (by class)}{
\itemize{
\item \code{getWhenMeasured(default)}: default

\item \code{getWhenMeasured(generic_spct)}: generic_spct

\item \code{getWhenMeasured(summary_generic_spct)}: summary_generic_spct

\item \code{getWhenMeasured(data.frame)}: data.frame

\item \code{getWhenMeasured(generic_mspct)}: generic_mspct

}}
\note{
If \code{x} is not an object of one of the supported classes,
  \code{NA} is returned.

The method for collections of spectra returns a tibble with the
  times expressed in TZ = "UTC".
}
\examples{
my.spct <- sun.spct
when_measured(my.spct)
when_measured(my.spct) <- lubridate::ymd_hms("2020-01-01 08:00:00")
when_measured(my.spct)
when_measured(my.spct) <- NULL
when_measured(my.spct)

}
\seealso{
Other measurement metadata functions: 
\code{\link{add_attr2tb}()},
\code{\link{getFilterProperties}()},
\code{\link{getHowMeasured}()},
\code{\link{getInstrDesc}()},
\code{\link{getInstrSettings}()},
\code{\link{getSoluteProperties}()},
\code{\link{getWhatMeasured}()},
\code{\link{getWhereMeasured}()},
\code{\link{get_attributes}()},
\code{\link{isValidInstrDesc}()},
\code{\link{isValidInstrSettings}()},
\code{\link{select_spct_attributes}()},
\code{\link{setFilterProperties}()},
\code{\link{setHowMeasured}()},
\code{\link{setInstrDesc}()},
\code{\link{setInstrSettings}()},
\code{\link{setSoluteProperties}()},
\code{\link{setWhatMeasured}()},
\code{\link{setWhenMeasured}()},
\code{\link{setWhereMeasured}()},
\code{\link{spct_attr2tb}()},
\code{\link{spct_metadata}()},
\code{\link{subset_attributes}()},
\code{\link{trimInstrDesc}()},
\code{\link{trimInstrSettings}()}
}
\concept{measurement metadata functions}
