% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imagebar_s.R
\name{imagebar_s}
\alias{imagebar_s}
\title{Plot a stacked bar chart with bars filled with png and jpeg images.}
\usage{
imagebar_s(
  data,
  x,
  y,
  group,
  xlab = "",
  ylab = "",
  pattern.type,
  label.size = 3.5,
  frame.color = "black",
  frame.size = 1,
  legend.type = "h",
  legend.h = 6,
  legend.x.pos = 1.1,
  legend.y.pos = 0.49,
  legend.w = 0.2,
  legend.pixel = 20,
  legend.label,
  bar.width = 0.9
)
}
\arguments{
\item{data}{the data to be used.}

\item{x}{the variable used on x axis.}

\item{y}{the variable used on y axis.}

\item{group}{the variable used as the second grouping variable on x axis.}

\item{xlab}{a character string to give x axis label.}

\item{ylab}{a character string to give y axis label.}

\item{pattern.type}{a list of objects returned by \code{readPNG} and \code{readJPEG} used to fill the stacked bars.}

\item{label.size}{the font size of legend labels shown above the stacked bars.}

\item{frame.color}{the color of the borders of the stacked bars.}

\item{frame.size}{a numeric value, the line size for the borders of the stacked bars.}

\item{legend.type}{if legend.type='h', the layout of legends is horizontal;
if legend.type='v', the layout of legends is vertical.}

\item{legend.h}{a numeric value to change the height of legend boxes.}

\item{legend.x.pos}{a numeric value to change the position of legends on x axis.}

\item{legend.y.pos}{a numeric value to change the position of legends on y axis.}

\item{legend.w}{a numeric value to change the width of legends.}

\item{legend.pixel}{a numeric value to change the pixel of legend boxes.}

\item{legend.label}{a vector to name legend labels.}

\item{bar.width}{a numeric value to change the width of the bars.}
}
\value{
A ggplot object.
}
\description{
The \code{imagebar_s} function is a tool for creating versatile stacked bar charts by filling the bars with external png and jpeg images.
}
\details{
\code{imagebar_s} function offers flexible ways of doing stacked bar charts.
}
\examples{
library(patternplot)
library(jpeg)
library(ggplot2)

childcare<-readJPEG(system.file("img", "childcare.jpg", package="patternplot"))
food<-readJPEG(system.file("img", "food.jpg", package="patternplot"))
housing <-readJPEG(system.file("img", "housing.jpg", package="patternplot"))

data <- read.csv(system.file("extdata", "monthlyexp.csv", package="patternplot"))
x<-data$Location
y<-data$Amount
group<-data$Type
pattern.type<-list(childcare, food, housing)

imagebar_s(data,x,y,group,xlab='',ylab='Monthly Expenses, Dollar',pattern.type=pattern.type,
label.size=3.5,frame.size=1,frame.color='black',legend.type='h',legend.h=6,legend.y.pos=0.49,
legend.pixel=20, legend.w=0.2,legend.x.pos=1.1,
legend.label=c("Childcare", "Food", "Housing"))+scale_y_continuous(limits = c(0, 6800))



}
\seealso{
Function \code{patternbar_s}
}
\author{
Chunqiao Luo (chunqiaoluo@gmail.com)
}
