% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/notcore_utils.r
\name{summary.vacalibration}
\alias{summary.vacalibration}
\title{Summary of results obtained by vacalibration}
\usage{
\method{summary}{vacalibration}(object, top = 5, rnd = 4, algorithm = NULL, ...)
}
\arguments{
\item{object}{\code{vacalibration} object}

\item{top}{number of top CSMF to show}

\item{rnd}{number of decimal places to round the CSMF}

\item{algorithm}{a name or vector of names of algorithm(s) which
limits the output to those specific results}

\item{\dots}{not used}
}
\description{
This function prints a summary message of the results along with
the top cause-specific mortality fractions (CSMFs).
}
\examples{
\dontrun{
data(NeonatesVA5)
fit_insilico <- codeVA(NeonatesVA5, auto.length = FALSE)
insilico_prep <- prepCalibration(fit_insilico)
calib_insilico = vacalibration::vacalibration(va_data = insilico_prep,
                                              age_group = "neonate",
                                              country = "Mozambique",
                                              plot_it = FALSE)
calib_insilico_summ <- summary(calib_insilico)
names(calib_insilico_summ)
calib_insilico_summ

fit_interva <- codeVA(NeonatesVA5, model = "InterVA", version = "5", write = FALSE)
interva_prep <- prepCalibration(fit_interva)
calib_interva = vacalibration::vacalibration(va_data = interva_prep,
                                             age_group = "neonate",
                                             country = "Mozambique",
                                             plot_it = FALSE)
summary(calib_interva, top = 3)

two_fits <- prepCalibration(fit_insilico, fit_interva)
calib_ensemble = vacalibration::vacalibration(va_data = two_fits,
                                              age_group = "neonate",
                                              country = "Mozambique",
                                              plot_it = FALSE)
summary(calib_ensemble)
}
}
