% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcc.R
\name{pcc}
\alias{pcc}
\title{Returns probabilities of correct classification for both groups in independent data partition.}
\usage{
pcc(data, pred.var, group.var, group.values)
}
\arguments{
\item{data}{Data frame including predicted values (e.g., pred.dat from D_regularized_out).}

\item{pred.var}{Character string. Variable name for predicted values.}

\item{group.var}{The name of the group variable.}

\item{group.values}{Vector of length 2, group values (e.g. c("male", "female) or c(0,1)).}
}
\value{
Vector of length 2. Probabilities of correct classification.
}
\description{
Returns probabilities of correct classification for both groups in independent data partition.
}
\examples{
D_out <- D_regularized(
  data = iris[iris$Species == "versicolor" | iris$Species == "virginica", ],
  mv.vars = c("Sepal.Length", "Sepal.Width", "Petal.Length", "Petal.Width"),
  group.var = "Species", group.values = c("versicolor", "virginica"),
  out = TRUE,
  size = 15
)

pcc(
  data = D_out$pred.dat,
  pred.var = "pred",
  group.var = "group",
  group.values = c("versicolor", "virginica")
)
}
