% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_app.R
\name{minimal.2halfFFD}
\alias{minimal.2halfFFD}
\title{Construct All Possible Minimally Changed Two-Level Half-Fractional Factorial Designs}
\usage{
minimal.2halfFFD()
}
\value{
Opens a user-friendly interactive shiny application for generating minimally
changed two-level half-fractional factorial designs
}
\description{
In Design of Experiments (DOE) theory, the two levels of a factor are commonly represented
as integers, for example, -1 for the low level and +1 for the high level.
The `minimal.2halfFFD()` function launches an interactive shiny application that enables
users to construct and explore all possible minimally changed two-level half-fractional
factorial designs. These designs are particularly useful in experiments involving
hard-to-change factors or situations where frequent factor-level changes are costly or
time-consuming.
}
\details{
The shiny application provides an intuitive and visually organized interface
for constructing and analyzing all possible minimally changed two-level
half-fractional factorial designs. It is particularly suited for experiments
where some factors are difficult or costly to change between runs.

The interface is divided into two main sections:

\strong{1. Input Panel (Left Side):}
\itemize{
  \item \emph{Enter Number of Factors} - Specify the number of two-level factors.
  The number must be greater than two.
  \item \emph{Trend Factor Range} - Enter the lower and upper bounds
  (values between 0 and 1)
  The upper bound must be greater than the lower bound.
  \item \emph{Generate Button} - Initiates the computation and triggers the
  generation of all possible minimally changed designs.
}

\strong{2. Results Panel (Right Side):}
After clicking the \emph{Generate} button, results are displayed in a
structured, color-coded layout. A dropdown menu titled
'Select Result to Display' allows users to choose what to view:
\itemize{
 \item \emph{Total Change} - Displays the sum of per-factor level changes of a run order.
  \item \emph{Total Number of Minimally Changed Designs} - Displays total number of all the minimally changed two-level half-fractional factorial designs.
  \item \emph{All Minimally Changed Designs} - Shows all the minimally changed two-level half-fractional factorial designs.
  \item \emph{All Minimally Changed Designs with D, Dt, Trend Factor} - Presents designs with corresponding
  D, Dt and Trend Factor values.
  \item \emph{Maximum D Value} - Maximum D-value within the generated minimally changed designs.
  \item \emph{D-Optimal Designs} - Designs with the Maximum D-value within the generated minimally changed designs.
  \item \emph{Maximum Dt Value} - Maximum Dt-value within the generated minimally changed designs.
  \item \emph{Dt-Optimal Designs} - Designs with the Maximum Dt-value within the generated minimally changed designs.
  \item \emph{Maximum Trend Factor} - Displays the Maximum Trend Factor Value for the generated minimally changed designs.
  \item \emph{Number of Minimally Changed Designs with Maximum Trend Factor Value} - Shows Number of minimally changed designs with Maximum Trend Factor value
  \item \emph{Minimally Changed Designs in Trend Factor Range} - Shows Minimally changed designs within the specified range of trend factor
}
}
\examples{
if (interactive()) {
  minimal.2halfFFD()
}

}
\references{
Bhowmik, A., Varghese, E., Jaggi, S., and Varghese, C. (2015).
Factorial experiments with minimum changes in run sequences.
\emph{Journal of the Indian Society of Agricultural Statistics}, 69(3), 243-255.

Bhowmik, A., Varghese, E., Jaggi, S., and Varghese, C. (2017).
Minimally changed run sequences in factorial experiments.
\emph{Communications in Statistics-Theory and Methods}, 46(15), 7444-7459.

Bhowmik, A., Varghese, E., Jaggi, S., and Varghese, C. (2020).
On the generation of factorial designs with minimum level changes.
\emph{Communications in Statistics-Simulation and Computation}, 51(6), 3400-3409.

Chanda, B., Bhowmik, A., Jaggi, S., Varghese, E., Datta, A., Varghese, C.,
Das Saha, N., Bhatia, A., and Chakrabarti, B. (2021).
Minimal cost multifactor experiments for agricultural research involving hard-to-change factors.
\emph{Indian Journal of Agricultural Sciences}, 91(7), 97-100.

Tack, L., and Vandebroek, M. (2001).
(Dt, C)-optimal run orders.
\emph{Journal of Statistical Planning and Inference}, 98, 293-310.
}
