% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imputes.R
\name{impute_lod}
\alias{impute_lod}
\title{Impute missing values by replacing them with the Feature 'Limit of Detection'}
\usage{
impute_lod(data, div_by = 5)
}
\arguments{
\item{data}{A tidy tibble created by \code{\link[metamorphr]{read_featuretable}}.}

\item{div_by}{A numeric value that specifies by which number the Feature minimum will be divided}
}
\value{
A tibble with imputed missing values.
}
\description{
Replace missing intensity values (\code{NA}) by what is assumed to be the detector limit of detection (LoD).
It is estimated by dividing the Feature minimum by the provided denominator, usually 5. See the References section for more information.
}
\examples{
toy_metaboscape \%>\%
  impute_lod()
}
\references{
\href{https://omicsforum.ca/t/how-to-deal-with-missing-values/75}{LoD on OmicsForum}
}
