% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_colebrook.R
\name{colebrook}
\alias{colebrook}
\alias{velocity}
\alias{reynolds_number}
\title{Calculates the Darcy-Weisbach Friction Factor f}
\usage{
velocity(D = NULL, Q = NULL)

reynolds_number(V = NULL, D = NULL, nu = NULL)

colebrook(ks, V, D, nu)
}
\arguments{
\item{D}{numeric vector that contains the pipe diameter [\eqn{m}{m} or \eqn{ft}{ft}]
which should be D >=0.0025 m (0.0082 ft).}

\item{Q}{(for velocity function only) numeric vector that contains the flow rate
[\eqn{m^3 s^{-1}}{m^3/s} or \eqn{ft^3 s^{-1}}{ft^3/s}]}

\item{V}{numeric vector that contains the average Velocity of flow in the pipe,
equal to flow divided by area, \eqn{\frac{Q}{A}}{Q/A} [\eqn{m\,s^{-1}}{m/s} or \eqn{ft\,s^{-1}}{ft/s}]}

\item{nu}{numeric vector that contains the kinematic viscosity of water,
[\eqn{m^2 s^{-1}}{m^2/s} or \eqn{ft^2 s^{-1}}{ft^2/s}]. Computed with a utility function in water_properties.R:
kvisc(T=T, units=['SI' or 'Eng'])}

\item{ks}{numeric vector that contains the 'equivalent sand roughness height
sand roughness height. Units should be consistent with other input [\eqn{m}{m} or \eqn{ft}{ft}]}
}
\value{
f Returns a numeric vector containing the Darcy-Weisbach friction
  factor
}
\description{
This function calculates the Darcy-Weisbach friction factor
and is only provided in this package for use with water in circular pipes
while the equation is technically valid for any liquid or channel.
As with many parts of this package, techniques and formatting
were drawn from Irucka Embry's iemisc package, which includes some
methods with similar functionality. Two utility functions are included for velocity 
and Reynolds Number.
}
\details{
The Colebrook-White equation was developed to estimate the Darcy-Weisbach friction factor
for commercial pipes under turbulent flow conditions. It is recommended for pipe diameters greater 
than 2.5 mm (0.1 inch).  The equation is: \deqn{\frac{1}{\sqrt{f}} = -2\log\left(\frac{\frac{ks}{D}}{3.7} + \frac{2.51}{Re\sqrt{f}}\right)}
where \eqn{Re = \frac{VD}{nu}} is the unitless Reynolds Number.
}
\examples{

# A Type 1 problem (solve for hf): US units
D <- 20/12   #diameter of 20 inches
Q <- 4       #flow in ft^3/s
T <- 60      #water temperature in F
ks <- 0.0005 #pipe roughness in ft

f <- colebrook(ks=ks,V=velocity(D,Q), D=D, nu=kvisc(T=T, units="Eng"))

}
\seealso{
\code{\link{kvisc}} for kinematic viscosity, \code{\link{velocity}} for
calculating \eqn{V=\frac{Q}{A}}{V=Q/A}, \code{\link{reynolds_number}} for Reynolds number
}
\author{
Ed Maurer
}
