#save the API key in the user r environment


#' Function and instructions creating the API_KEY variable in the User environment.
#' @param verbose \code{logical} If logical, then the instruction message will show. Default \code{TRUE}.
#' @importFrom utils file.edit
#'
#' @return string of instructions for saving or setting the API in the R session.
#' @export
#'
fw_setapikey <- function(verbose = TRUE){

  if(verbose)cat("  =============================================",'\n',
      "=============================================",'\n',
      "PLEASE FOLLOW THE INSTRUCTIONS CAREFULLY",'\n',
      "=============================================",'\n',
      "1. PLEASE EDIT THE .Renviron THATS HAS OPENED",'\n',
      "==                                         ",'\n',
      "2. TYPE IN: API_KEY = 36-digits alphanumeric",'\n',
      "==                                         ",'\n',
      "3. SAVE AND CLOSE. RESTART RSESSION",'\n',
      "==                                         ",'\n',
      "4. CONGS: YOUR ARE READY TO GO!!!!!!!!",'\n',
      "============================================",'\n',
      "============================================",'\n')

  file.edit("~/.Renviron")
}


#'For loading the API key from the environment.
#' @param keyvar \code{string} Is the API name as indicated in the user environment. Default is \code{"API_KEY"}.
#' @return string of API
#' @export
fw_keyload <- function(keyvar= "API_KEY") {

  # check if the API Key is saved already and possibly not the case

  key_loaded <- Sys.getenv(x = keyvar)

  if(key_loaded=="") stop('The API key has not been well set in the .Renviron file. Run fw_setapikey() and follow the instruction carefully.', call. = FALSE)

  if(grepl("[A-Za-z0-9]", key_loaded) !=TRUE) stop("The key provided save in .Renviron is wrong. Please repeat saving and run again.", call. = FALSE)

  if (nchar(key_loaded) != 36) stop("Please check the API Key provided it exceeds 36 characters.")

  cat(
    " ========================================================================", "\n",
    "Congratulations!!! Ready to interact with www.freshwaterecology.info database", "\n",
    "=========================================================================", "\n"
  )
  return(key_loaded)
}




