% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createCobraPred.R
\name{createCobraPred}
\alias{createCobraPred}
\title{Create COBRA Predictions}
\usage{
createCobraPred(
  train,
  test,
  n_train,
  n_test,
  nlearners,
  eps,
  alpha,
  train_target
)
}
\arguments{
\item{train}{A \code{matrix} representing the training data. Rows represent observations,
and columns contain predictions from individual learners for these observations.
In cases where a prediction is unavailable for a specific observation, \code{NA} is used.}

\item{test}{A \code{matrix} representing the test data. Rows represent observations,
and columns contain predictions from individual learners for these observations.
In cases where a prediction is unavailable for a specific observation, \code{NA} is used.}

\item{n_train}{An \code{integer} specifying the number of training observations.}

\item{n_test}{An \code{integer} specifying the number of test observations.}

\item{nlearners}{An \code{integer} representing the number of learners.}

\item{eps}{A \code{numeric} value representing the threshold for proximity between two predictions.}

\item{alpha}{A value that determines the optimal number of learners in the neighborhood (only for alpha optimization).}

\item{train_target}{A \code{vector} containing the target values for the training dataset}
}
\description{
The \code{createCobraPred} function calculates predictions by averaging the target
values of all the nearest candidates in the training dataset. Only the
training points that are within the specified proximity (\code{eps}) to the test
point are used to determine the prediction. If no suitable training points
are found, the function returns \code{NA} as the prediction.
}
