% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fire_exp_validate_plot.R
\name{fire_exp_validate_plot}
\alias{fire_exp_validate_plot}
\title{Visualize validation outputs in a plot}
\usage{
fire_exp_validate_plot(
  validation_table,
  what = c("both", "total", "sample"),
  title
)
}
\arguments{
\item{validation_table}{The output table from \code{\link[=fire_exp_validate]{fire_exp_validate()}}}

\item{what}{string. Which plot should be returned? Can be \code{"sample"},
\code{"total"},or \code{"both"} (Default)}

\item{title}{Optional. String. Add a custom title to the plot.}
}
\value{
a ggplot object
}
\description{
\code{fire_exp_validate_plot()} Visualizes the results from
\code{fire_exp_validate()} in a bar plot
}
\examples{
# read example hazard data
hazard_file_path <- "extdata/hazard.tif"
hazard <- terra::rast(system.file(hazard_file_path, package = "fireexposuR"))

polygon_path <- system.file("extdata", "polygon.shp", package ="fireexposuR")
polygon <- terra::vect(polygon_path)
no_burn <- terra::rasterize(polygon, hazard)

# generate example fire polygons by buffering random points
points <- terra::spatSample(terra::rescale(hazard, 0.8),
                            30, as.points = TRUE)
fires <- terra::buffer(points, 800)
# PLEASE NOTE THIS EXAMPLE DATA DOES NOT GENERATE MEANINGFUL RESULTS

# compute exposure and remove non-burnable cells
exposure <- fire_exp(hazard, no_burn = no_burn)

# results as table
validation_outputs <- fire_exp_validate(exposure, fires)

# results as bar chart
fire_exp_validate_plot(validation_outputs)

}
\seealso{
\code{\link[=fire_exp_validate]{fire_exp_validate()}}
}
