% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulations_collection.R
\name{as_tibble.simulations_collection}
\alias{as_tibble.simulations_collection}
\title{Convert a simulations_collection to a tibble}
\usage{
\method{as_tibble}{simulations_collection}(x, target_dose = NULL, alpha = 0.05, ...)
}
\arguments{
\item{x}{object of type \code{\link{simulations_collection}}}

\item{target_dose}{numerical dose index, or NULL (default) for all doses}

\item{alpha}{significance level for symmetrical confidence intervals}

\item{...}{extra args are ignored}
}
\value{
a tibble with cols:
\itemize{
 \item \code{dose}, the dose-level
 \item \code{n}, cumulative inference using the first n simulated iterations
 \item \code{design.x}, The first design in the comparison, aka design X
 \item \code{hit.x}, logical showing if design X recommended dose in iterate n
 \item \code{design.y}, The second design in the comparison, aka design Y
 \item \code{hit.x}, logical showing if design Y recommended dose in iterate n
 \item \code{X}, cumulative sum of hit.x within dose, i.e. count of recommendations
 \item \code{X2}, cumulative sum of hit.x^2 within dose
 \item \code{Y}, cumulative sum of hit.y within dose, i.e. count of recommendations
 \item \code{Y2}, cumulative sum of hit.y^2 within dose
 \item \code{XY}, cumulative sum of hit.x * hit.y within dose
 \item \code{psi1}, X / n
 \item \code{psi2}, Y / n
 \item \code{v_psi1}, variance of psi1
 \item \code{v_psi2}, variance of psi2
 \item \code{cov_psi12}, covariance of psi1 and psi2
 \item \code{delta}, psi1 - psi2
 \item \code{v_delta}, variance of delta
 \item \code{se_delta}, standard error of delta
 \item \code{delta_l}, delta - q * se_delta, where q is alpha / 2 normal quantile
 \item \code{delta_u}, delta + q * se_delta, where q is alpha / 2 normal quantile
 \item \code{comparison}, Label of design.x vs design.y, using design names
}
}
\description{
Cumulative statistics are shown to gauge how the simulations converge.
}
