% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pick.R
\name{pick_elements}
\alias{pick_elements}
\alias{pick1}
\alias{pick2}
\title{Extract (pick) elements without using brackets}
\usage{
pick1(x, which)

pick2(x, which)
}
\arguments{
\item{x}{A list, data frame, or vector.}

\item{which}{The index or name of the element(s) to extract.}
}
\value{
\itemize{
\item \code{pick1()} returns a subset of \code{x}.
\item \code{pick2()} returns a single element from \code{x}.
}
}
\description{
Extract (pick) elements without using brackets so that elements can be picked out as part of a pipe workflow.
}
\details{
These two helper functions extract elements from lists, data frames, or vectors.
They are simple wrappers for the standard bracket operators in R:
\itemize{
\item \code{pick1()} uses single brackets (\code{[}) and returns a \strong{subset}.
\item \code{pick2()} uses double brackets (\code{[[}) and returns the \strong{element itself}.
}

These are safer and more flexible than \code{$}, especially when used with the base R pipe (\verb{|>})
or in functional programming.
}
\examples{
lst <- list(a = 1:3, b = 4:6)

# Without pipe
pick1(lst, "a")      # List with one element
pick2(lst, "a")      # Just the vector 1:3

# With base R pipe
lst |> pick1("a")
lst |> pick2("a")

df <- data.frame(x = 1:5, y = letters[1:5])

df |> pick1("y")     # Returns a data frame with column 'y'
df |> pick2("y")     # Returns column 'y' as a character vector

}
