% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/queries.R
\name{edge_types}
\alias{edge_types}
\title{Get the edge types of a \code{caugi}.}
\usage{
edge_types(cg)
}
\arguments{
\item{cg}{A \code{caugi} object.}
}
\value{
A character vector of edge types.
}
\description{
Get the edge types of a \code{caugi}.
}
\examples{
cg <- caugi(
  A \%-->\% B,
  B \%--o\% C,
  C \%<->\% D,
  D \%---\% E,
  A \%o-o\% E,
  class = "UNKNOWN"
)
edge_types(cg) # returns c("-->", "o-o", "--o", "<->", "---")

}
\seealso{
Other queries: 
\code{\link{ancestors}()},
\code{\link{children}()},
\code{\link{descendants}()},
\code{\link{edges}()},
\code{\link{exogenous}()},
\code{\link{is_acyclic}()},
\code{\link{is_caugi}()},
\code{\link{is_cpdag}()},
\code{\link{is_dag}()},
\code{\link{is_empty_caugi}()},
\code{\link{is_pdag}()},
\code{\link{is_ug}()},
\code{\link{markov_blanket}()},
\code{\link{neighbors}()},
\code{\link{nodes}()},
\code{\link{parents}()},
\code{\link{same_nodes}()},
\code{\link{subgraph}()}
}
\concept{queries}
