## ----include = FALSE----------------------------------------------------------
Sys.setenv(R_USER_LIBS = tempdir())  #Just in case for CRAN
library(biodosetools)
knitr::opts_chunk$set(
  fig.dpi = 96,
  collapse = TRUE,
  comment = "#>"
)

## ----sc-micro-estimate-01, echo=FALSE, out.width='100%', fig.align='center', fig.cap="'Curve fitting data options' box and 'Results' tabbed box in the dose estimation module when loading curve from an `.rds` file."----
knitr::include_graphics("figures/screenshot-micronuclei-estimate-01.png")

## ----sc-micro-estimate-01b, echo=FALSE, out.width='100%', fig.cap="'Curve fitting data options' box and 'Results' tabbed box in the dose estimation module when inputting curve coefficients manually. Note that if no variance-covariance matrix is provided, only the variances calculated from the coefficients' standard errors will be used in calculations."----
knitr::include_graphics("figures/screenshot-micronuclei-estimate-02.png")

## ----load-fitting-results, tidy=TRUE, tidy.opts=list(width.cutoff=60)---------
fit_results <- system.file("extdata", "micronuclei-fitting-results.rds", package = "biodosetools") %>%
  readRDS()

## ----fit-results--------------------------------------------------------------
fit_results$fit_coeffs

## ----sc-micro-estimate-02, echo=FALSE, out.width='100%', fig.align='center', fig.cap="'Data input options' and 'Data input' boxes in the dose estimation module."----
knitr::include_graphics("figures/screenshot-micronuclei-estimate-03.png")

## ----micro-case-data----------------------------------------------------------
case_data <- data.frame(
  ID = 'Case1', C0 = 302, C1 = 28, C2 = 22, C3 = 8, C4 = 1
) %>%
  calculate_aberr_table(
    type = "case",
    assessment_u = 1,
    aberr_module = "micronuclei"
  )

## -----------------------------------------------------------------------------
case_data

## ----sc-micro-estimate-03, echo=FALSE, out.width='60%', fig.align='center', fig.cap="'Dose estimation options' box in the dose estimation module."----
knitr::include_graphics("figures/screenshot-micronuclei-estimate-04.png")

## ----sc-micro-estimate-04, echo=FALSE, out.width='100%', fig.align='center', fig.cap="'Results' tabbed box, 'Curve plot' and 'Save results' boxes in the dose estimation module."----
knitr::include_graphics("figures/screenshot-micronuclei-estimate-05.png")

## ----micro-parse-fit-results--------------------------------------------------
fit_coeffs <- fit_results[["fit_coeffs"]]
fit_var_cov_mat <- fit_results[["fit_var_cov_mat"]]

## ----micro-protracted-g-value-------------------------------------------------
protracted_g_value <- protracted_g_function(
  time = 0.5,
  time_0 = 2
)

## -----------------------------------------------------------------------------
protracted_g_value

## ----micro-dose-estimation-whole----------------------------------------------
results_whole_merkle <- estimate_whole_body_merkle(
  num_cases = 1,
  case_data,
  fit_coeffs,
  fit_var_cov_mat,
  conf_int_yield = 0.95,
  conf_int_curve = 0.95,
  protracted_g_value,
  aberr_module = "micronuclei"
)

## ----micro-estimated-dose-curve, fig.width=6, fig.height=3.5, fig.align='center', fig.cap="Plot of estimated doses generated by \\{biodosetools\\}. The grey shading indicates the uncertainties associated with the calibration curve."----
plot_estimated_dose_curve(
  est_doses = list(whole = results_whole_merkle),
  fit_coeffs,
  fit_var_cov_mat,
  protracted_g_value = 1,
  conf_int_curve = 0.95,
  aberr_name = "Micronuclei",
  place = "UI"
)

