% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-label-aligned.R
\name{geom_label_aligned}
\alias{geom_label_aligned}
\title{Non-overlapping label boxes}
\usage{
geom_label_aligned(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  ...,
  label_r = 0.15,
  alignment = "vertical",
  min_distance = 0.1,
  background_rect = TRUE,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link{aes}} or
\code{\link{aes_}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
   options:

   If \code{NULL}, the default, the data is inherited from the plot
   data as specified in the call to \code{\link{ggplot}}.

   A \code{data.frame}, or other object, will override the plot
   data. All objects will be fortified to produce a data frame. See
   \code{\link{fortify}} for which variables will be created.

   A \code{function} will be called with a single argument,
   the plot data. The return value must be a \code{data.frame.}, and
   will be used as the layer data.}

\item{stat}{The statistical transformation to use on the data for this
layer, as a string.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{...}{other arguments passed on to \code{\link{layer}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{color = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{label_r}{Radius of rounded corners. Defaults to 0.15 lines.}

\item{alignment}{One of "vertical" (QP on Y axis) or "horizontal" (QP on X axis)}

\item{min_distance}{Minimum distance between boxes in pixels.}

\item{background_rect}{Disables text background rect if set to FALSE.}

\item{na.rm}{If \code{FALSE} (the default), removes missing values with
a warning.  If \code{TRUE} silently removes missing values.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link{borders}}.}
}
\description{
This geom creates boxes with labels that are aligned either vertically or horizontally,
using quadratic programming to optimize their positions and avoid overlaps. The QP solver
is applied after all showSelected filtering occurs, and operates as follows:
}
\details{
For vertical alignment (default):
- QP optimizes Y positions while keeping X positions fixed
- Constraints ensure boxes don't overlap vertically
- Boxes are aligned along the vertical axis at their original X positions

For horizontal alignment:
- QP optimizes X positions while keeping Y positions fixed
- Constraints ensure boxes don't overlap horizontally
- Boxes are aligned along the horizontal axis at their original Y positions

The QP solver minimizes the total squared distance from original positions while
enforcing minimum spacing constraints between boxes.
}
\examples{
library(nlme)
data(BodyWeight, package = "nlme")
# Extracting the last point of each rat's trajectory
library(data.table)
label_data <- data.table(BodyWeight)[Time == max(Time)][order(weight)]
rfac=function(x)factor(paste(x), paste(label_data$Rat))
BodyWeight$rat=rfac(BodyWeight$Rat)
label_data$rat=rfac(label_data$Rat)
library(animint2)
viz <- animint(
  bodyPlot = ggplot() +
    theme_bw() +
    theme_animint(width=1000)+
    geom_line(aes(
      x = Time, y = weight,
      group = rat),
      clickSelects="rat",
      size=3,
      data = BodyWeight) +
    geom_line(aes(
      x = Time, y = weight,
      group = rat, key = rat, colour = rat),
      clickSelects="rat",
      data = BodyWeight) +
    geom_label_aligned(aes(
      x = Time + 1, y = weight,
      key = rat, label = rat, fill = rat),
      clickSelects="rat",
      hjust = 0,
      data = label_data) +
    facet_grid(~Diet, labeller=label_both) +
    ggtitle("rat body weight over time by diet") +
    xlab("Time (days)") +
    ylab("Body Weight (grams)"),
  duration=list(rat=1000)
)
viz
}
