% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/japan.R
\name{alarm_japan}
\alias{alarm_japan}
\alias{alarm_japan_map}
\alias{alarm_japan_plans}
\alias{alarm_japan_stats}
\alias{alarm_japan_doc}
\title{Download maps and plans from the Japan 47-Prefecture Simulation Project}
\usage{
alarm_japan_map(pref, year = 2022, refresh = FALSE)

alarm_japan_plans(
  pref,
  stats = TRUE,
  year = 2022,
  refresh = FALSE,
  compress = "xz"
)

alarm_japan_stats(pref, year = 2022, refresh = FALSE)

alarm_japan_doc(pref, year = 2022)
}
\arguments{
\item{pref}{A prefecture name}

\item{year}{The redistricting cycle to download. Currently only \code{2022} is available.}

\item{refresh}{If \code{TRUE}, ignore the cache and download again.}

\item{stats}{If \code{TRUE} (the default), download summary statistics for each plan.}

\item{compress}{The compression level used for caching \link[redist:redist_plans]{redist_plans} objects.}
}
\value{
For \code{alarm_japan_map()}, a \link[redist:redist_map]{redist_map}. For
\code{alarm_japan_plans()}, a \link[redist:redist_plans]{redist_plans}. For
\code{alarm_japan_doc()}, invisibly returns the path to the HTML documentation,
and also loads an HTML file into the viewer or web browser.
For \code{alarm_japan_stats()}, a \link[dplyr:reexports]{tibble}.
}
\description{
These functions will download \link[redist:redist_map]{redist_map} and
\link[redist:redist_plans]{redist_plans} objects for the Japan 47-Prefecture Simulation
Project from the ALARM Project's Dataverse. \code{alarm_japan_doc()} will
download documentation for a particular prefecture and show it in a browser.
\code{alarm_japan_stats} will download just the summary statistics for a prefecture
}
\details{
The goal of the 47-Prefecture Simulation Project is to generate and analyze
redistricting plans for the single-member districts of the House of Representatives
of Japan using a redistricting simulation algorithm.
In this project, we analyzed the partisan bias of the 2022 redistricting
for 25 prefectures subject to redistricting.
Our simulations are designed to comply with the that the Council abides by.
}
\examples{
\dontshow{if (Sys.getenv("DATAVERSE_KEY") != '') withAutoprint(\{ # examplesIf}

# requires Harvard Dataverse API key
alarm_japan_map("miyagi")
alarm_japan_plans("miyagi", stats = FALSE)
alarm_japan_stats("miyagi")
alarm_japan_doc("miyagi")

map <- alarm_japan_map("miyagi")
pl <- alarm_japan_plans("miyagi")
\dontshow{\}) # examplesIf}
}
